/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wps.response;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.opengis.ows11.ExceptionReportType;
import net.opengis.wps10.ExecuteResponseType;
import org.geotools.data.ows.Response;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.geotools.wps.WPSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.xml.sax.SAXException;

public class ExecuteProcessResponse
extends Response {
    private ExecuteResponseType exeResponse;
    private ExceptionReportType excepResponse;
    private InputStream rawResponseStream;
    private String rawContentType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteProcessResponse(HTTPResponse httpResponse, boolean raw) throws IOException, ServiceException {
        block11: {
            super(httpResponse);
            try (InputStream inputStream = null;){
                block12: {
                    if (!raw) {
                        inputStream = httpResponse.getResponseStream();
                        this.parseDocumentResponse(inputStream);
                        break block11;
                    }
                    this.rawContentType = httpResponse.getContentType();
                    if (this.rawContentType.matches(".*/xml.*")) {
                        inputStream = new BufferedInputStream(httpResponse.getResponseStream());
                        inputStream.mark(8192);
                        try {
                            XMLInputFactory factory = XMLInputFactory.newFactory();
                            factory.setProperty("javax.xml.stream.supportDTD", false);
                            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                            XMLStreamReader parser = factory.createXMLStreamReader(inputStream, "UTF-8");
                            while (parser.hasNext() && 1 != parser.next()) {
                            }
                            String name = parser.getName().getLocalPart();
                            inputStream.reset();
                            if ("ServiceException".equals(name) || "ExceptionReport".equals(name) || "ExecuteResponse".equals(name)) {
                                this.parseDocumentResponse(inputStream);
                                return;
                            }
                            break block12;
                        }
                        catch (XMLStreamException e) {
                            throw new IOException("Failed to parse the response", e);
                        }
                    }
                    inputStream = httpResponse.getResponseStream();
                }
                this.rawResponseStream = inputStream;
                inputStream = null;
            }
        }
    }

    private void parseDocumentResponse(InputStream inputStream) throws IOException {
        Object object;
        WPSConfiguration config = new WPSConfiguration();
        Parser parser = new Parser((Configuration)config);
        this.excepResponse = null;
        this.exeResponse = null;
        try {
            object = parser.parse(inputStream);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw (IOException)new IOException().initCause(e);
        }
        if (object instanceof ExecuteResponseType) {
            this.exeResponse = (ExecuteResponseType)object;
            if (this.exeResponse.getStatus() != null && this.exeResponse.getStatus().getProcessFailed() != null) {
                this.excepResponse = this.exeResponse.getStatus().getProcessFailed().getExceptionReport();
            }
        } else if (object instanceof ExceptionReportType) {
            this.excepResponse = (ExceptionReportType)object;
        }
    }

    public ExecuteResponseType getExecuteResponse() {
        return this.exeResponse;
    }

    public ExceptionReportType getExceptionResponse() {
        return this.excepResponse;
    }

    public InputStream getRawResponseStream() {
        return this.rawResponseStream;
    }

    public String getRawContentType() {
        return this.rawContentType;
    }
}

