/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wps;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.opengis.wps10.DescriptionType;
import net.opengis.wps10.ProcessDescriptionType;
import org.geotools.api.data.Parameter;
import org.geotools.api.util.InternationalString;
import org.geotools.data.wps.WPSProcess;
import org.geotools.data.wps.WPSUtils;
import org.geotools.process.Process;
import org.geotools.process.ProcessFactory;
import org.geotools.process.impl.SingleProcessFactory;
import org.geotools.text.Text;

public class WPSFactory
extends SingleProcessFactory {
    private ProcessDescriptionType pdt;
    private URL serverUrl;
    private String version;
    private String title;
    private String identifier;
    private String description;
    private Map<String, Parameter<?>> parameterInfo = new TreeMap();
    private Map<String, Parameter<?>> resultInfo = new TreeMap();

    public WPSFactory(ProcessDescriptionType pdt, URL serverUrl) {
        this.pdt = pdt;
        this.serverUrl = serverUrl;
        this.buildValuesFromProcessDescriptionType();
    }

    private void buildValuesFromProcessDescriptionType() {
        this.version = this.pdt.getProcessVersion();
        this.title = this.pdt.getTitle().getValue();
        this.identifier = this.pdt.getIdentifier().getValue();
        this.description = WPSUtils.isAbstractNull((DescriptionType)this.pdt) ? "" : this.pdt.getAbstract().getValue();
        this.parameterInfo = WPSUtils.createInputParamMap(this.pdt, this.parameterInfo);
        this.resultInfo = WPSUtils.createOutputParamMap(this.pdt, this.resultInfo);
    }

    public Process create() {
        return new WPSProcess((ProcessFactory)this);
    }

    public InternationalString getDescription() {
        return Text.text((String)this.description);
    }

    public Map<String, Parameter<?>> getParameterInfo() {
        return Collections.unmodifiableMap(this.parameterInfo);
    }

    public Map<String, Parameter<?>> getResultInfo(Map<String, Object> parameters) throws IllegalArgumentException {
        return Collections.unmodifiableMap(this.resultInfo);
    }

    public InternationalString getTitle() {
        return Text.text((String)this.title);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean supportsProgress() {
        return false;
    }

    public ProcessDescriptionType getProcessDescriptionType() {
        return this.pdt;
    }

    public URL getServerURL() {
        return this.serverUrl;
    }
}

