/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wps.request;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.wps10.DataInputsType1;
import net.opengis.wps10.DataType;
import net.opengis.wps10.ExecuteType;
import net.opengis.wps10.InputReferenceType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.ResponseFormType;
import net.opengis.wps10.Wps10Factory;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.wps.request.AbstractWPSRequest;
import org.geotools.data.wps.request.ExecuteProcessRequest;
import org.geotools.wps.WPS;
import org.geotools.wps.WPSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;

public abstract class AbstractExecuteProcessRequest
extends AbstractWPSRequest
implements ExecuteProcessRequest {
    private boolean usePost = true;
    private Properties inputs = new Properties();
    protected ResponseFormType responseForm;

    public AbstractExecuteProcessRequest(URL onlineResource, Properties properties) {
        super(onlineResource, properties);
    }

    protected void initRequest() {
        this.setProperty("REQUEST", "Execute");
    }

    @Override
    public void setIdentifier(String identifier) {
        this.setProperty("IDENTIFIER", identifier);
    }

    protected abstract void initVersion();

    public boolean requiresPost() {
        return this.usePost;
    }

    public void performPostOutput(OutputStream outputStream) throws IOException {
        WPSConfiguration config = new WPSConfiguration();
        Encoder encoder = new Encoder((Configuration)config);
        encoder.setIndenting(true);
        ExecuteType request = this.createExecuteType();
        encoder.encode((Object)request, WPS.Execute, outputStream);
    }

    private ExecuteType createExecuteType() {
        ExecuteType request = Wps10Factory.eINSTANCE.createExecuteType();
        CodeType codetype = Ows11Factory.eINSTANCE.createCodeType();
        String iden = (String)this.properties.get("IDENTIFIER");
        codetype.setValue(iden);
        request.setIdentifier(codetype);
        request.setService("WPS");
        request.setVersion("1.0.0");
        if (this.inputs != null && !this.inputs.isEmpty()) {
            DataInputsType1 inputtypes = Wps10Factory.eINSTANCE.createDataInputsType1();
            Set<Object> keyset = this.inputs.keySet();
            for (Object key : keyset) {
                List objects = (List)this.inputs.get(key);
                for (EObject oInput : objects) {
                    CodeType ct;
                    InputType input;
                    if (oInput instanceof DataType) {
                        DataType dt = (DataType)oInput;
                        input = Wps10Factory.eINSTANCE.createInputType();
                        ct = Ows11Factory.eINSTANCE.createCodeType();
                        ct.setValue((String)key);
                        input.setIdentifier(ct);
                        input.setData(dt);
                        inputtypes.getInput().add((Object)input);
                        continue;
                    }
                    if (oInput instanceof InputReferenceType) {
                        InputReferenceType rt = (InputReferenceType)oInput;
                        input = Wps10Factory.eINSTANCE.createInputType();
                        ct = Ows11Factory.eINSTANCE.createCodeType();
                        ct.setValue((String)key);
                        input.setIdentifier(ct);
                        input.setReference(rt);
                        inputtypes.getInput().add((Object)input);
                        continue;
                    }
                    throw new IllegalStateException("The input for key " + key + " contain an unsupported object of type " + oInput.getClass());
                }
            }
            request.setDataInputs(inputtypes);
        }
        if (this.responseForm != null) {
            request.setResponseForm(this.responseForm);
        }
        return request;
    }

    @Override
    public void addInput(String name, List<EObject> value) {
        if (value == null) {
            this.inputs.remove(name);
        } else {
            for (EObject o : value) {
                if (o instanceof DataType || o instanceof InputReferenceType) continue;
                throw new IllegalArgumentException("The values can be either of type net.opengis.wps10.DataType or of type net.opengis.wps10.InputReferenceType");
            }
            this.inputs.put(name, value);
        }
    }

    @Override
    public void setResponseForm(ResponseFormType responseForm) {
        if (responseForm != null) {
            this.responseForm = responseForm;
        }
    }
}

