/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wps;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.opengis.ows11.DCPType;
import net.opengis.ows11.HTTPType;
import net.opengis.ows11.OperationType;
import net.opengis.ows11.RequestMethodType;
import net.opengis.wps10.OutputDefinitionType;
import net.opengis.wps10.ProcessOfferingsType;
import net.opengis.wps10.ResponseDocumentType;
import net.opengis.wps10.ResponseFormType;
import net.opengis.wps10.WPSCapabilitiesType;
import org.eclipse.emf.ecore.EObject;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.ServiceInfo;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.Request;
import org.geotools.data.ows.Specification;
import org.geotools.data.wps.AbstractWPS;
import org.geotools.data.wps.AbstractWPSGetCapabilitiesResponse;
import org.geotools.data.wps.WPS1_0_0;
import org.geotools.data.wps.WPSSpecification;
import org.geotools.data.wps.request.DescribeProcessRequest;
import org.geotools.data.wps.request.ExecuteProcessRequest;
import org.geotools.data.wps.response.DescribeProcessResponse;
import org.geotools.data.wps.response.ExecuteProcessResponse;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.geotools.wps.WPS;

public class WebProcessingService
extends AbstractWPS<WPSCapabilitiesType, Object> {
    public static URL getOperationURL(String operation, WPSCapabilitiesType cap, boolean getGet) {
        for (OperationType next : cap.getOperationsMetadata().getOperation()) {
            if (operation.compareToIgnoreCase(next.getName()) != 0) continue;
            for (DCPType next2 : next.getDCP()) {
                HTTPType http = next2.getHTTP();
                if (getGet && !http.getGet().isEmpty()) {
                    RequestMethodType rmt = (RequestMethodType)http.getGet().get(0);
                    return WebProcessingService.makeURL(rmt.getHref());
                }
                if (http.getPost().isEmpty()) continue;
                RequestMethodType rmt = (RequestMethodType)http.getPost().get(0);
                return WebProcessingService.makeURL(rmt.getHref());
            }
            return null;
        }
        return null;
    }

    private static URI makeURI(String s) {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static URL makeURL(String s) {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public WebProcessingService(WPSCapabilitiesType capabilities) throws IOException, ServiceException {
        super(WebProcessingService.getOperationURL("getcapabilities", capabilities, true), HTTPClientFinder.createClient(), capabilities);
    }

    public WebProcessingService(URL serverURL) throws IOException, ServiceException {
        super(serverURL);
    }

    public WebProcessingService(URL serverURL, HTTPClient httpClient, WPSCapabilitiesType capabilities) throws IOException, ServiceException {
        super(serverURL, httpClient, capabilities);
    }

    @Override
    protected void setupSpecifications() {
        this.specs = new Specification[1];
        this.specs[0] = new WPS1_0_0();
    }

    @Override
    protected ServiceInfo createInfo() {
        return new WPSInfo();
    }

    @Override
    protected ResourceInfo createInfo(Object resource) {
        return null;
    }

    @Override
    public AbstractWPSGetCapabilitiesResponse issueRequest(GetCapabilitiesRequest request) throws IOException, ServiceException {
        return (AbstractWPSGetCapabilitiesResponse)this.internalIssueRequest((Request)request);
    }

    public DescribeProcessResponse issueRequest(DescribeProcessRequest request) throws IOException, ServiceException {
        return (DescribeProcessResponse)this.internalIssueRequest(request);
    }

    public ExecuteProcessResponse issueRequest(ExecuteProcessRequest request) throws IOException, ServiceException {
        return (ExecuteProcessResponse)this.internalIssueRequest(request);
    }

    public ExecuteProcessResponse issueStatusRequest(URL statusURL) throws IOException, ServiceException {
        HTTPResponse httpResponse = this.httpClient.get(statusURL);
        return new ExecuteProcessResponse(httpResponse, false);
    }

    public WPSCapabilitiesType getCapabilities() {
        return this.capabilities;
    }

    public DescribeProcessRequest createDescribeProcessRequest() throws UnsupportedOperationException {
        if (this.getCapabilities().getProcessOfferings() == null) {
            throw new UnsupportedOperationException("Server does not specify a DescribeProcess operation. Cannot be performed.");
        }
        URL onlineResource = WebProcessingService.getOperationURL("describeprocess", this.capabilities, true);
        if (onlineResource == null) {
            onlineResource = this.serverURL;
        }
        DescribeProcessRequest request = this.getSpecification().createDescribeProcessRequest(onlineResource);
        return request;
    }

    public ExecuteProcessRequest createExecuteProcessRequest() throws UnsupportedOperationException {
        ProcessOfferingsType processOfferings = this.getCapabilities().getProcessOfferings();
        if (processOfferings == null || !processOfferings.eAllContents().hasNext()) {
            throw new UnsupportedOperationException("Server does not specify any processes to execute. Cannot be performed.");
        }
        URL onlineResource = WebProcessingService.getOperationURL("execute", this.capabilities, true);
        if (onlineResource == null) {
            onlineResource = this.serverURL;
        }
        ExecuteProcessRequest request = this.getSpecification().createExecuteProcessRequest(onlineResource);
        return request;
    }

    private WPSSpecification getSpecification() {
        return (WPSSpecification)this.specification;
    }

    public EObject createLiteralInputValue(String literalValue) {
        return this.getSpecification().createLiteralInputValue(literalValue);
    }

    public EObject createBoundingBoxInputValue(String crs, int dimensions, List<Double> lowerCorner, List<Double> upperCorner) {
        return this.getSpecification().createBoundingBoxInputValue(crs, dimensions, lowerCorner, upperCorner);
    }

    public ResponseFormType createResponseForm(ResponseDocumentType responseDoc, OutputDefinitionType rawOutput) {
        return this.getSpecification().createResponseForm(responseDoc, rawOutput);
    }

    public ResponseDocumentType createResponseDocumentType(boolean lineage, boolean status, boolean storeExecuteResponse, String outputType) {
        return this.getSpecification().createResponseDocumentType(lineage, status, storeExecuteResponse, outputType);
    }

    public OutputDefinitionType createOutputDefinitionType(String identifier) {
        return this.getSpecification().createOutputDefinitionType(identifier);
    }

    protected class WPSInfo
    implements ServiceInfo {
        private Set<String> keywords = new HashSet<String>();

        WPSInfo() {
            this.keywords.add("WPS");
            this.keywords.add(WebProcessingService.this.serverURL.toString());
        }

        public String getDescription() {
            String description = null;
            if (description == null && WebProcessingService.this.serverURL != null) {
                description = "Web Processing Service " + WebProcessingService.this.serverURL;
            }
            return description;
        }

        public Set<String> getKeywords() {
            return this.keywords;
        }

        public URI getPublisher() {
            try {
                return new URI(WebProcessingService.this.serverURL.getProtocol() + ":" + WebProcessingService.this.serverURL.getHost());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }

        public URI getSchema() {
            return WebProcessingService.makeURI(WPS.getInstance().getNamespaceURI());
        }

        public URI getSource() {
            try {
                URL source = WebProcessingService.getOperationURL("getcapabilities", WebProcessingService.this.capabilities, true);
                return source.toURI();
            }
            catch (NullPointerException | URISyntaxException source) {
                try {
                    return WebProcessingService.this.serverURL.toURI();
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        }

        public String getTitle() {
            if (WebProcessingService.this.serverURL == null) {
                return "Unavailable";
            }
            return WebProcessingService.this.serverURL.toString();
        }
    }
}

