/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wps;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import net.opengis.ows11.DomainMetadataType;
import net.opengis.wps10.ComplexDataCombinationsType;
import net.opengis.wps10.ComplexDataDescriptionType;
import net.opengis.wps10.ComplexDataType;
import net.opengis.wps10.DataInputsType;
import net.opengis.wps10.DataType;
import net.opengis.wps10.DescriptionType;
import net.opengis.wps10.ExecuteResponseType;
import net.opengis.wps10.InputDescriptionType;
import net.opengis.wps10.LiteralDataType;
import net.opengis.wps10.LiteralInputType;
import net.opengis.wps10.LiteralOutputType;
import net.opengis.wps10.OutputDataType;
import net.opengis.wps10.OutputDescriptionType;
import net.opengis.wps10.ProcessDescriptionType;
import net.opengis.wps10.ProcessOutputsType;
import net.opengis.wps10.SupportedComplexDataInputType;
import net.opengis.wps10.SupportedComplexDataType;
import net.opengis.wps10.Wps10Factory;
import org.eclipse.emf.common.util.EList;
import org.geotools.api.data.Parameter;
import org.geotools.api.util.InternationalString;
import org.geotools.text.Text;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public class WPSUtils {
    private static final Logger LOGGER = Logging.getLogger(WPSUtils.class);
    public static final int INPUTTYPE_LITERAL = 1;
    public static final int INPUTTYPE_COMPLEXDATA = 2;

    public static DataType createInputDataType(Object obj, InputDescriptionType idt) {
        int inputtype = 0;
        LiteralInputType literalData = idt.getLiteralData();
        SupportedComplexDataInputType complexData = idt.getComplexData();
        inputtype = literalData != null ? 1 : (complexData != null ? 2 : (obj instanceof String || obj instanceof Double || obj instanceof Float || obj instanceof Integer ? 1 : 2));
        String schema = null;
        if (inputtype == 2) {
            ComplexDataCombinationsType supported = complexData.getSupported();
            ComplexDataDescriptionType cddt = (ComplexDataDescriptionType)supported.getFormat().get(0);
            schema = cddt.getSchema();
        }
        return WPSUtils.createInputDataType(obj, inputtype, schema);
    }

    public static DataType createInputDataType(Object obj, int type, String schema) {
        return WPSUtils.createInputDataType(obj, type, schema, null);
    }

    public static DataType createInputDataType(Object obj, int type, String schema, String mimeType) {
        DataType dt = Wps10Factory.eINSTANCE.createDataType();
        if (type == 1) {
            LiteralDataType ldt = Wps10Factory.eINSTANCE.createLiteralDataType();
            ldt.setValue(obj.toString());
            dt.setLiteralData(ldt);
        } else {
            ComplexDataType cdt = Wps10Factory.eINSTANCE.createComplexDataType();
            cdt.getData().add(obj);
            if (schema != null) {
                cdt.setSchema(schema);
            }
            if (mimeType != null) {
                cdt.setMimeType(mimeType);
            }
            dt.setComplexData(cdt);
        }
        return dt;
    }

    public static Map<String, Parameter<?>> createInputParamMap(ProcessDescriptionType processDesc, Map<String, Parameter<?>> map) {
        DataInputsType dataInputs;
        if (map == null) {
            map = new TreeMap();
        }
        if ((dataInputs = processDesc.getDataInputs()) == null) {
            return null;
        }
        EList inputs = dataInputs.getInput();
        if (inputs == null || inputs.isEmpty()) {
            return null;
        }
        for (InputDescriptionType idt : inputs) {
            LiteralInputType literalData = idt.getLiteralData();
            SupportedComplexDataInputType complexData = idt.getComplexData();
            Class type = Object.class;
            if (literalData != null) {
                String reference = literalData.getDataType().getReference();
                type = WPSUtils.getLiteralTypeFromReference(reference);
            } else if (complexData != null) {
                ComplexDataDescriptionType format = complexData.getDefault().getFormat();
                String encoding = format.getEncoding();
                String mimetype = format.getMimeType();
                String schema = format.getSchema();
                if (encoding == null) {
                    encoding = "";
                }
                if (mimetype == null) {
                    mimetype = "";
                }
                if (schema == null) {
                    schema = "";
                }
                type = WPSUtils.getComplexType(encoding, mimetype, schema);
            }
            boolean required = true;
            if (idt.getMinOccurs().intValue() < 1) {
                required = false;
            }
            String identifier = idt.getIdentifier().getValue();
            InternationalString title = Text.text((String)idt.getTitle().getValue());
            InternationalString description = Text.text((String)(WPSUtils.isAbstractNull((DescriptionType)idt) ? "" : idt.getAbstract().getValue()));
            Parameter param = new Parameter(identifier, type, title, description, required, idt.getMinOccurs().intValue(), idt.getMaxOccurs().intValue(), null, null);
            map.put(identifier, param);
        }
        return map;
    }

    public static Map<String, Parameter<?>> createOutputParamMap(ProcessDescriptionType processDesc, Map<String, Parameter<?>> map) {
        ProcessOutputsType processOutputs;
        if (map == null) {
            map = new TreeMap();
        }
        if ((processOutputs = processDesc.getProcessOutputs()) == null) {
            return null;
        }
        EList outputs = processOutputs.getOutput();
        if (outputs == null || outputs.isEmpty()) {
            return null;
        }
        for (OutputDescriptionType odt : outputs) {
            LiteralOutputType literalOutput = odt.getLiteralOutput();
            SupportedComplexDataType complexOutput = odt.getComplexOutput();
            Class type = Object.class;
            if (literalOutput != null) {
                DomainMetadataType dataType = literalOutput.getDataType();
                if (dataType != null) {
                    Class literalType = null;
                    if (dataType.getReference() != null && (literalType = WPSUtils.guessLiteralType(dataType.getReference())) == null) {
                        LOGGER.warning("Unparsable ows:reference " + dataType.getReference());
                    }
                    if (literalType == null) {
                        literalType = WPSUtils.guessLiteralType(dataType.getValue());
                    }
                    type = literalType != null ? literalType : String.class;
                } else {
                    type = String.class;
                }
            } else if (complexOutput != null) {
                ComplexDataDescriptionType format = complexOutput.getDefault().getFormat();
                String encoding = format.getEncoding();
                String mimetype = format.getMimeType();
                String schema = format.getSchema();
                if (encoding == null) {
                    encoding = "";
                }
                if (mimetype == null) {
                    mimetype = "";
                }
                if (schema == null) {
                    schema = "";
                }
                type = WPSUtils.getComplexType(encoding, mimetype, schema);
            }
            InternationalString description = Text.text((String)(WPSUtils.isAbstractNull((DescriptionType)odt) ? "" : odt.getAbstract().getValue()));
            Parameter param = new Parameter(odt.getIdentifier().getValue(), type, Text.text((String)odt.getTitle().getValue()), description);
            map.put(odt.getIdentifier().getValue(), param);
        }
        return map;
    }

    public static boolean isAbstractNull(DescriptionType description) {
        if (description.getAbstract() == null) {
            return true;
        }
        return description.getAbstract().getValue() == null;
    }

    private static Class getLiteralTypeFromReference(String ref) {
        Class<String> guess = WPSUtils.guessLiteralType(ref);
        return guess != null ? guess : String.class;
    }

    private static Class guessLiteralType(String s) {
        String u = s.toUpperCase();
        if (u.contains("DOUBLE")) {
            return Double.class;
        }
        if (u.contains("INTEGER")) {
            return Integer.class;
        }
        if (u.contains("FLOAT")) {
            return Float.class;
        }
        if (u.contains("BOOLEAN")) {
            return Boolean.TYPE;
        }
        if (u.contains("CHAR")) {
            return Character.class;
        }
        if (u.contains("STRING")) {
            return String.class;
        }
        return null;
    }

    private static Class getComplexType(String encoding, String mimetype, String schema) {
        if (encoding.toUpperCase().contains("GML") || mimetype.toUpperCase().contains("GML") || schema.toUpperCase().contains("GML")) {
            return Geometry.class;
        }
        if (encoding.toUpperCase().contains("POLYGON") || mimetype.toUpperCase().contains("POLYGON") || schema.toUpperCase().contains("POLYGON")) {
            return Geometry.class;
        }
        if (encoding.toUpperCase().contains("POINT") || mimetype.toUpperCase().contains("POINT") || schema.toUpperCase().contains("POINT")) {
            return Geometry.class;
        }
        if (encoding.toUpperCase().contains("LINE") || mimetype.toUpperCase().contains("LINE") || schema.toUpperCase().contains("LINE")) {
            return Geometry.class;
        }
        if (encoding.toUpperCase().contains("RING") || mimetype.toUpperCase().contains("RING") || schema.toUpperCase().contains("RING")) {
            return Geometry.class;
        }
        return Object.class;
    }

    public static Map<String, Object> createResultMap(ExecuteResponseType ert, Map<String, Object> map) {
        EList outputs;
        if (map == null) {
            map = new TreeMap<String, Object>();
        }
        if ((outputs = ert.getProcessOutputs().getOutput()) == null) {
            return null;
        }
        for (OutputDataType odt : outputs) {
            DataType data = odt.getData();
            ComplexDataType complexData = data.getComplexData();
            LiteralDataType literalData = data.getLiteralData();
            if (literalData != null) {
                Object value = literalData.getValue();
                if (literalData.getDataType() != null) {
                    Class type = WPSUtils.getLiteralTypeFromReference(literalData.getDataType());
                    Object convertedValue = Converters.convert((Object)literalData.getValue(), (Class)type);
                    if (convertedValue != null) {
                        value = convertedValue;
                    }
                }
                map.put(odt.getIdentifier().getValue(), value);
                continue;
            }
            if (complexData == null) continue;
            EList datas = complexData.getData();
            if (datas.size() > 1) {
                Iterator iterator2 = datas.iterator();
                ArrayList values = new ArrayList();
                while (iterator2.hasNext()) {
                    Object value = iterator2.next();
                    values.add(value);
                }
                map.put(odt.getIdentifier().getValue(), values);
                continue;
            }
            map.put(odt.getIdentifier().getValue(), datas.get(0));
        }
        return map;
    }
}

