/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wps;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import net.opengis.wps10.DataType;
import net.opengis.wps10.ExecuteResponseType;
import net.opengis.wps10.InputDescriptionType;
import net.opengis.wps10.ProcessDescriptionType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.wps.WPSFactory;
import org.geotools.data.wps.WPSUtils;
import org.geotools.data.wps.WebProcessingService;
import org.geotools.data.wps.request.ExecuteProcessRequest;
import org.geotools.data.wps.response.ExecuteProcessResponse;
import org.geotools.ows.ServiceException;
import org.geotools.process.ProcessFactory;
import org.geotools.process.impl.AbstractProcess;
import org.opengis.util.ProgressListener;

public class WPSProcess
extends AbstractProcess {
    protected WPSProcess(ProcessFactory factory) {
        super(factory);
    }

    public Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) {
        ExecuteProcessResponse response;
        WebProcessingService wps;
        WPSFactory wpsfactory = (WPSFactory)this.factory;
        ProcessDescriptionType pdt = wpsfactory.getProcessDescriptionType();
        URL url = wpsfactory.getServerURL();
        try {
            wps = new WebProcessingService(url);
        }
        catch (IOException | ServiceException e) {
            return null;
        }
        ExecuteProcessRequest exeRequest = wps.createExecuteProcessRequest();
        exeRequest.setIdentifier(wpsfactory.getIdentifier());
        EList inputs = pdt.getDataInputs().getInput();
        for (InputDescriptionType idt : inputs) {
            DataType createdInput;
            String identifier = idt.getIdentifier().getValue();
            Object inputValue = input.get(identifier);
            if (inputValue == null) continue;
            ArrayList<EObject> list = new ArrayList<EObject>();
            if (inputValue instanceof Map) {
                for (Object inVal : ((Map)inputValue).values()) {
                    createdInput = WPSUtils.createInputDataType(inVal, idt);
                    list.add((EObject)createdInput);
                }
            } else if (inputValue instanceof Collection) {
                for (Object inVal : (Collection)inputValue) {
                    createdInput = WPSUtils.createInputDataType(inVal, idt);
                    list.add((EObject)createdInput);
                }
            } else {
                DataType createdInput2 = WPSUtils.createInputDataType(inputValue, idt);
                list.add((EObject)createdInput2);
            }
            exeRequest.addInput(identifier, list);
        }
        try {
            response = wps.issueRequest(exeRequest);
        }
        catch (IOException | ServiceException e) {
            return null;
        }
        if (response.getExceptionResponse() != null || response.getExecuteResponse() == null) {
            return null;
        }
        ExecuteResponseType executeResponse = response.getExecuteResponse();
        Map<String, Object> results = new TreeMap<String, Object>();
        results = WPSUtils.createResultMap(executeResponse, results);
        return results;
    }
}

