/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.request;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.Response;
import org.geotools.data.ows.SimpleHttpClient;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.ows.wmts.client.WMTSTileFactory;
import org.geotools.ows.wmts.client.WMTSTileService;
import org.geotools.ows.wmts.model.TileMatrixLimits;
import org.geotools.ows.wmts.model.TileMatrixSet;
import org.geotools.ows.wmts.model.TileMatrixSetLink;
import org.geotools.ows.wmts.model.WMTSCapabilities;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.ows.wmts.model.WMTSServiceType;
import org.geotools.ows.wmts.request.AbstractWMTSRequest;
import org.geotools.ows.wmts.request.GetTileRequest;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.tile.Tile;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractGetTileRequest
extends AbstractWMTSRequest
implements GetTileRequest {
    private static final int MAXTILES = 256;
    static WMTSTileFactory factory = new WMTSTileFactory();
    public static final String LAYER = "Layer";
    public static final String STYLE = "Style";
    public static final String TILECOL = "TileCol";
    public static final String TILEROW = "TileRow";
    public static final String TILEMATRIX = "TileMatrix";
    public static final String TILEMATRIXSET = "TileMatrixSet";
    public static final String FORMAT = "Format";
    private final HTTPClient client;
    protected WMTSLayer layer = null;
    protected String styleName = "";
    private String srs;
    static final Logger LOGGER = Logging.getLogger(AbstractGetTileRequest.class);
    protected WMTSServiceType type;
    protected WMTSCapabilities capabilities;
    private ReferencedEnvelope requestedBBox;
    private int requestedHeight;
    private int requestedWidth;
    private String requestedTime;
    private CoordinateReferenceSystem crs;
    private final Map<String, String> headers = new HashMap<String, String>();
    private String format = "image/png";

    public AbstractGetTileRequest(URL onlineResource, Properties properties) {
        this(onlineResource, properties, (HTTPClient)new SimpleHttpClient());
    }

    public AbstractGetTileRequest(URL onlineResource, Properties properties, HTTPClient client) {
        super(onlineResource, properties);
        Objects.requireNonNull(client, "client");
        this.client = client;
    }

    protected abstract void initVersion();

    protected void initRequest() {
        this.setProperty("REQUEST", "GetTile");
    }

    public Response createResponse(HTTPResponse response) throws ServiceException, IOException {
        return null;
    }

    @Override
    public void setLayer(WMTSLayer layer) {
        StyleImpl defaultStyle;
        if (layer == null) {
            throw new IllegalArgumentException("Attempt to add a NULL layer to WMTS");
        }
        this.layer = layer;
        if (this.styleName.isEmpty() && (defaultStyle = layer.getDefaultStyle()) != null) {
            this.styleName = defaultStyle.getName();
        }
    }

    @Override
    public void setStyle(String styleName) {
        this.styleName = styleName;
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public void setRequestedHeight(int height) {
        this.requestedHeight = height;
    }

    @Override
    public void setRequestedWidth(int width) {
        this.requestedWidth = width;
    }

    @Override
    public void setRequestedBBox(ReferencedEnvelope requestedBBox) {
        this.requestedBBox = requestedBBox;
    }

    @Override
    public void setRequestedTime(String requestedTime) {
        this.requestedTime = requestedTime;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    @Override
    public void setCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public Set<Tile> getTiles() throws ServiceException {
        if (this.layer == null) {
            throw new ServiceException("GetTiles called with no layer set");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getTiles: layer:" + (Object)((Object)this.layer));
        }
        String layerString = "";
        String styleString = "";
        try {
            layerString = URLEncoder.encode(this.layer.getName(), "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException | NullPointerException e) {
            layerString = layerString + this.layer.getName();
        }
        this.styleName = this.styleName == null ? "" : this.styleName;
        try {
            styleString = URLEncoder.encode(this.styleName, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException | NullPointerException e1) {
            styleString = styleString + this.styleName;
        }
        this.setProperty(LAYER, layerString);
        this.setProperty(STYLE, styleString);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getTiles:  layer:" + (Object)((Object)this.layer) + " w:" + this.requestedWidth + " x h:" + this.requestedHeight);
        }
        TileMatrixSet matrixSet = this.selectMatrixSet();
        String format = (String)this.getProperties().get(FORMAT);
        if (StringUtils.isEmpty((CharSequence)format) && !this.layer.getFormats().isEmpty()) {
            format = this.layer.getFormats().get(0);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Format is not set, available formats: " + this.layer.getFormats() + " -- Selecting " + format);
            }
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = "image/png";
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Format not set, trying with " + format);
            }
        }
        String requestUrl = this.getFinalURL().toExternalForm();
        WMTSTileService wmtsService = new WMTSTileService(requestUrl, this.type, this.layer, styleString, matrixSet, this.client);
        wmtsService.setFormat(format);
        wmtsService.getDimensions().put("time", this.requestedTime);
        ((Map)wmtsService.getExtrainfo().computeIfAbsent("HEADERS", extra -> new HashMap())).putAll(this.headers);
        double scale = Math.round(RendererUtilities.calculateOGCScale((ReferencedEnvelope)this.requestedBBox, (int)this.requestedWidth, null));
        Set<Tile> tiles = wmtsService.findTilesInExtent(this.requestedBBox, (int)scale, false, 256);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("found " + tiles.size() + " tiles in " + this.requestedBBox);
        }
        if (tiles.isEmpty()) {
            return tiles;
        }
        Tile first = tiles.iterator().next();
        int z = first.getTileIdentifier().getZ();
        TileMatrixSetLink tmsl = this.layer.getTileMatrixLinks().get(matrixSet.getIdentifier());
        TileMatrixLimits limit = WMTSTileFactory.getLimits(tmsl, matrixSet, z);
        ArrayList<Tile> tilesOutsideLimits = new ArrayList<Tile>();
        for (Tile tile : tiles) {
            int x = tile.getTileIdentifier().getX();
            int y = tile.getTileIdentifier().getY();
            if ((long)x < limit.getMincol() || (long)x > limit.getMaxcol()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("col " + x + " outside limits " + limit.getMincol() + " " + limit.getMaxcol());
                }
                tilesOutsideLimits.add(tile);
                continue;
            }
            if ((long)y >= limit.getMinrow() && (long)y <= limit.getMaxrow()) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("row " + y + " outside limits " + limit.getMinrow() + " " + limit.getMaxrow());
            }
            tilesOutsideLimits.add(tile);
        }
        tiles.removeAll(tilesOutsideLimits);
        return tiles;
    }

    public URL getFinalURL() {
        String requestUrl = this.onlineResource.toString();
        if (WMTSServiceType.REST.equals((Object)this.type) && (requestUrl = this.layer.getTemplate(this.format)) == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Template URL not available for format  " + this.format);
            }
            this.type = WMTSServiceType.KVP;
            requestUrl = this.onlineResource.toString();
        }
        URL ret = null;
        try {
            ret = new URL(requestUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private TileMatrixSet selectMatrixSet() throws ServiceException, RuntimeException {
        TileMatrixSet retMatrixSet = null;
        Map<String, TileMatrixSetLink> links = this.layer.getTileMatrixLinks();
        CoordinateReferenceSystem requestCRS = this.getCrs();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("request CRS " + (requestCRS == null ? "NULL" : requestCRS.getName()));
        }
        if (requestCRS == null) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("request CRS decoding" + this.srs);
                }
                requestCRS = CRS.decode((String)this.srs);
            }
            catch (FactoryException e) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                }
                throw new RuntimeException(e);
            }
        }
        String requestSRS = CRS.toSRS((CoordinateReferenceSystem)requestCRS);
        for (TileMatrixSet matrixSet : this.capabilities.getMatrixSets()) {
            CoordinateReferenceSystem matrixCRS = matrixSet.getCoordinateReferenceSystem();
            String matrixSRS = CRS.toSRS((CoordinateReferenceSystem)matrixCRS);
            if (!requestSRS.equals(matrixSRS) || !links.containsKey(matrixSet.getIdentifier())) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("selected matrix set:" + matrixSet.getIdentifier());
            }
            this.setProperty(TILEMATRIXSET, matrixSet.getIdentifier());
            retMatrixSet = matrixSet;
            break;
        }
        if (retMatrixSet == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Failed to match the requested CRS (" + requestCRS.getName() + ") with any of the tile matrices!");
            }
            for (TileMatrixSet matrix : this.capabilities.getMatrixSets()) {
                if (!links.containsKey(matrix.getIdentifier())) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("defaulting matrix set:" + matrix.getIdentifier());
                }
                this.setProperty(TILEMATRIXSET, matrix.getIdentifier());
                retMatrixSet = matrix;
                break;
            }
        }
        if (retMatrixSet == null) {
            throw new ServiceException("Unable to find a matching TileMatrixSet for layer " + this.layer.getName() + " and SRS: " + requestCRS.getName());
        }
        return retMatrixSet;
    }
}

