/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.xml.Dimension;
import org.geotools.ows.wmts.WebMapTileServer;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.ows.wmts.request.GetTileRequest;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.tile.Tile;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.grid.Format;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class WMTSCoverageReader
extends AbstractGridCoverage2DReader {
    public static final Logger LOGGER = Logging.getLogger(WMTSCoverageReader.class);
    static GridCoverageFactory gcf = new GridCoverageFactory();
    WebMapTileServer wmts;
    WMTSLayer layer = null;
    String srsName;
    String format;
    private GetTileRequest tileRequest;
    GridCoverage2D grid;
    Set<String> validSRS;
    ReferencedEnvelope bounds;
    int width;
    int height;
    CoordinateReferenceSystem requestCRS;
    String requestedTime;
    public final boolean debug = System.getProperty("wmts.debug") != null;

    public WMTSCoverageReader(WebMapTileServer server, Layer layer) {
        this.wmts = server;
        this.setLayer(layer);
        List<String> formats = ((WMTSLayer)layer).getFormats();
        this.format = formats.iterator().next();
        for (String f : formats) {
            if (!"image/png".equals(f) && !"image/png24".equals(f) && !"png".equals(f) && !"png24".equals(f) && !"image/png; mode=24bit".equals(f)) continue;
            this.format = f;
            break;
        }
    }

    final void setLayer(Layer owsLayer) {
        CoordinateReferenceSystem crs;
        block16: {
            this.layer = (WMTSLayer)owsLayer;
            if (this.srsName == null) {
                for (String preferred : new String[]{"EPSG:4326", "WGS84", "CRS:84", "WGS 84", "WGS84(DD)"}) {
                    if (!owsLayer.getSrs().contains(preferred)) continue;
                    this.srsName = preferred;
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("defaulting CRS to: " + this.srsName);
                }
                if (this.srsName == null) {
                    for (String srs : owsLayer.getSrs()) {
                        try {
                            CRS.decode((String)srs);
                            this.srsName = srs;
                            if (!LOGGER.isLoggable(Level.INFO)) break;
                            LOGGER.info("setting CRS: " + this.srsName);
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                if (this.srsName == null) {
                    if (owsLayer.getSrs().isEmpty()) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("adding default CRS to: " + this.srsName);
                        }
                        this.srsName = "EPSG:4326";
                        owsLayer.getSrs().add(this.srsName);
                    } else {
                        this.srsName = (String)owsLayer.getSrs().iterator().next();
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("guessing CRS to: " + this.srsName);
                        }
                    }
                }
                this.validSRS = owsLayer.getSrs();
            } else {
                LOGGER.severe("TODO: check if this code path is ever run");
                HashSet<String> intersection = new HashSet<String>(this.validSRS);
                intersection.retainAll(owsLayer.getSrs());
                if (!intersection.contains(this.srsName)) {
                    if (intersection.isEmpty()) {
                        throw new IllegalArgumentException("The layer being appended does not have any SRS in common with the ones already included in the  request, cannot be merged");
                    }
                    this.srsName = intersection.contains("EPSG:4326") ? "EPSG:4326" : (String)intersection.iterator().next();
                    this.validSRS = intersection;
                }
            }
            crs = null;
            try {
                crs = CRS.decode((String)this.srsName);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.INFO)) break block16;
                LOGGER.log(Level.INFO, "Bounds unavailable for layer" + owsLayer);
            }
        }
        this.crs = crs;
        this.requestCRS = crs;
        this.updateBounds();
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        GeneralEnvelope requestedEnvelope = null;
        int width = -1;
        int height = -1;
        String time = null;
        for (Dimension dim : this.layer.getLayerDimensions()) {
            if (!"time".equalsIgnoreCase(dim.getName())) continue;
            time = dim.getExtent().getDefaultValue();
            if (!LOGGER.isLoggable(Level.FINE)) break;
            LOGGER.fine("TIME dimension found, default is " + time);
            break;
        }
        if (this.requestedTime != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("TIME dimension requested: " + this.requestedTime);
            }
            time = this.requestedTime;
        }
        if (parameters != null) {
            for (GeneralParameterValue param : parameters) {
                ReferenceIdentifier name = param.getDescriptor().getName();
                if (!name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) continue;
                GridGeometry2D gg = (GridGeometry2D)((ParameterValue)param).getValue();
                requestedEnvelope = gg.getEnvelope();
                width = gg.getGridRange().getHigh(0) + 1;
                height = gg.getGridRange().getHigh(1) + 1;
            }
        }
        if (requestedEnvelope == null) {
            requestedEnvelope = this.getOriginalEnvelope();
            width = 640;
            height = (int)Math.round(requestedEnvelope.getSpan(1) / requestedEnvelope.getSpan(0) * 640.0);
        }
        if (this.grid != null && this.grid.getGridGeometry().getGridRange2D().getWidth() == (double)width && this.grid.getGridGeometry().getGridRange2D().getHeight() == (double)height && this.grid.getEnvelope().equals(requestedEnvelope)) {
            return this.grid;
        }
        this.grid = this.getMap(this.reference((org.opengis.geometry.Envelope)requestedEnvelope), width, height, time);
        return this.grid;
    }

    GridCoverage2D getMap(ReferencedEnvelope requestedEnvelope, int width, int height, String time) throws IOException {
        ReferencedEnvelope gridEnvelope = this.initTileRequest(requestedEnvelope, width, height, time);
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Issuing request: " + this.getTileRequest().getFinalURL(), new RuntimeException("TRACE!"));
            }
            this.getTileRequest().setCRS(gridEnvelope.getCoordinateReferenceSystem());
            Set<Tile> responses = this.wmts.issueRequest(this.getTileRequest());
            if (responses.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Found 0 tiles in " + requestedEnvelope);
                }
                throw new RuntimeException("No tiles were found in requested extent");
            }
            AffineTransform at = null;
            ReferencedEnvelope global = null;
            for (Tile tile : responses) {
                ReferencedEnvelope extent = tile.getExtent();
                if (global == null) {
                    global = new ReferencedEnvelope(extent);
                } else {
                    global.expandToInclude((Envelope)extent);
                }
                BufferedImage bi = tile.getBufferedImage();
                if (at != null) continue;
                at = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)extent, (Rectangle)new Rectangle(bi.getWidth(), bi.getHeight()));
            }
            int imageWidth = (int)Math.round(global.getWidth() * at.getScaleX());
            int imageHeight = (int)Math.abs(Math.round(global.getHeight() * at.getScaleY()));
            BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
            AffineTransform targetTransform = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)global, (Rectangle)new Rectangle(0, 0, imageWidth, imageHeight));
            this.renderTiles(responses, image.createGraphics(), requestedEnvelope, targetTransform);
            return gcf.create((CharSequence)this.layer.getTitle(), (RenderedImage)image, (org.opengis.geometry.Envelope)global);
        }
        catch (ServiceException e) {
            throw new IOException("GetMap failed", e);
        }
    }

    protected void renderTiles(Collection<Tile> tiles, Graphics2D g2d, ReferencedEnvelope viewportExtent, AffineTransform worldToImageTransform) {
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        double[] inPoints = new double[4];
        double[] outPoints = new double[4];
        for (Tile tile : tiles) {
            ReferencedEnvelope tileEnvViewport;
            ReferencedEnvelope nativeTileEnvelope = tile.getExtent();
            try {
                tileEnvViewport = nativeTileEnvelope.transform(viewportExtent.getCoordinateReferenceSystem(), true);
            }
            catch (FactoryException | TransformException e) {
                throw new RuntimeException(e);
            }
            inPoints[0] = tileEnvViewport.getMinX();
            inPoints[3] = tileEnvViewport.getMinY();
            inPoints[2] = tileEnvViewport.getMaxX();
            inPoints[1] = tileEnvViewport.getMaxY();
            worldToImageTransform.transform(inPoints, 0, outPoints, 0, 2);
            this.renderTile(tile, g2d, outPoints);
            if (!this.debug) continue;
            g2d.setColor(Color.RED);
            g2d.drawRect((int)outPoints[0], (int)outPoints[1], (int)Math.ceil(outPoints[2] - outPoints[0]), (int)Math.ceil(outPoints[3] - outPoints[1]));
            int x = (int)outPoints[0] + (int)(Math.ceil(outPoints[2] - outPoints[0]) / 2.0);
            int y = (int)outPoints[1] + (int)(Math.ceil(outPoints[3] - outPoints[1]) / 2.0);
            g2d.drawString(tile.getId(), x, y);
        }
    }

    protected void renderTile(Tile tile, Graphics2D g2d, double[] points) {
        BufferedImage img = this.getTileImage(tile);
        if (img == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("couldn't draw " + tile.getId());
            }
            return;
        }
        int width = (int)Math.round(points[2] - points[0]);
        int height = (int)Math.round(points[3] - points[1]);
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        g2d.drawImage(img, (int)Math.round(points[0]), (int)Math.round(points[1]), width, height, null);
    }

    protected BufferedImage getTileImage(Tile tile) {
        return tile.getBufferedImage();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    ReferencedEnvelope initTileRequest(ReferencedEnvelope bbox, int width, int height, String time) throws IOException {
        ReferencedEnvelope gridEnvelope = bbox;
        String requestSrs = this.srsName;
        try {
            String code = null;
            Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)bbox.getCoordinateReferenceSystem(), (boolean)false);
            code = epsgCode != null ? "EPSG:" + epsgCode : CRS.lookupIdentifier((IdentifiedObject)bbox.getCoordinateReferenceSystem(), (boolean)false);
            if (code != null && this.validSRS.contains(code)) {
                requestSrs = code;
            } else {
                gridEnvelope = bbox.transform(this.getCoordinateReferenceSystem(), true);
                if (gridEnvelope.getWidth() < gridEnvelope.getHeight()) {
                    height = (int)Math.round((double)width * gridEnvelope.getHeight() / gridEnvelope.getWidth());
                } else {
                    width = (int)Math.round((double)height * gridEnvelope.getWidth() / gridEnvelope.getHeight());
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Could not reproject the request envelope", e);
        }
        GetTileRequest tileRequest = this.wmts.createGetTileRequest();
        this.setTileRequest(tileRequest);
        tileRequest.setCRS(gridEnvelope.getCoordinateReferenceSystem());
        tileRequest.setLayer(this.layer);
        tileRequest.setRequestedHeight(height);
        tileRequest.setRequestedWidth(width);
        tileRequest.setRequestedBBox(gridEnvelope);
        tileRequest.setRequestedTime(time);
        try {
            this.requestCRS = CRS.decode((String)requestSrs);
        }
        catch (Exception e) {
            throw new IOException("Could not decode request SRS " + requestSrs);
        }
        this.width = width;
        this.height = height;
        return gridEnvelope;
    }

    public Format getFormat() {
        return null;
    }

    public void updateBounds() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("WMTSCoverage", "updatingBounds");
        }
        GeneralEnvelope envelope = this.layer.getEnvelope(this.requestCRS);
        ReferencedEnvelope result = this.reference(envelope);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting bounds to " + result);
        }
        this.bounds = result;
        this.originalEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)result);
    }

    ReferencedEnvelope reference(org.opengis.geometry.Envelope envelope) {
        ReferencedEnvelope env = new ReferencedEnvelope(envelope.getCoordinateReferenceSystem());
        env.expandToInclude(envelope.getMinimum(0), envelope.getMinimum(1));
        env.expandToInclude(envelope.getMaximum(0), envelope.getMaximum(1));
        return env;
    }

    ReferencedEnvelope reference(GeneralEnvelope ge) {
        return new ReferencedEnvelope(ge.getMinimum(0), ge.getMaximum(0), ge.getMinimum(1), ge.getMaximum(1), ge.getCoordinateReferenceSystem());
    }

    public String[] getMetadataNames() {
        return new String[]{"ReprojectingReader"};
    }

    public String getMetadataValue(String name) {
        if ("ReprojectingReader".equals(name)) {
            return "true";
        }
        return super.getMetadataValue(name);
    }

    public GetTileRequest getTileRequest() {
        return this.tileRequest;
    }

    public void setTileRequest(GetTileRequest mapRequest) {
        this.tileRequest = mapRequest;
    }

    public String getRequestedTime() {
        return this.requestedTime;
    }

    public void setRequestedTime(String requestedTime) {
        this.requestedTime = requestedTime;
    }
}

