/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.SimpleHttpClient;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.ows.wmts.client.WMTSTileFactory;
import org.geotools.ows.wmts.client.WMTSZoomLevel;
import org.geotools.ows.wmts.model.TileMatrix;
import org.geotools.ows.wmts.model.TileMatrixSet;
import org.geotools.ows.wmts.model.TileMatrixSetLink;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.ows.wmts.model.WMTSServiceType;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.tile.Tile;
import org.geotools.tile.TileFactory;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.ScaleZoomLevelMatcher;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class WMTSTileService
extends TileService {
    protected static final Logger LOGGER = Logging.getLogger(WMTSTileService.class);
    public static final String DIMENSION_TIME = "time";
    public static final String DIMENSION_ELEVATION = "elevation";
    public static final String EXTRA_HEADERS = "HEADERS";
    private static final TileFactory tileFactory = new WMTSTileFactory();
    private String tileMatrixSetName = "";
    private double[] scaleList;
    private TileMatrixSet matrixSet;
    private final WMTSLayer layer;
    private String layerName;
    private String styleName = "";
    private ReferencedEnvelope envelope;
    private String templateURL = "";
    private WMTSServiceType type = WMTSServiceType.REST;
    private String format = "image/png";
    private Map<String, String> dimensions = new HashMap<String, String>();
    private Map<String, Object> extrainfo = new HashMap<String, Object>();

    public WMTSTileService(String templateURL, WMTSServiceType type, WMTSLayer layer, String styleName, TileMatrixSet tileMatrixSet) {
        this(templateURL, type, layer, styleName, tileMatrixSet, (HTTPClient)new SimpleHttpClient());
    }

    public WMTSTileService(String templateURL, WMTSServiceType type, WMTSLayer layer, String styleName, TileMatrixSet tileMatrixSet, HTTPClient client) {
        super("wmts", templateURL, client);
        this.layer = layer;
        this.tileMatrixSetName = tileMatrixSet.getIdentifier();
        this.envelope = new ReferencedEnvelope((org.opengis.geometry.Envelope)layer.getLatLonBoundingBox());
        this.scaleList = WMTSTileService.buildScaleList(tileMatrixSet);
        this.setTemplateURL(templateURL);
        this.setLayerName(layer.getName());
        if (styleName != null && !styleName.isEmpty()) {
            this.setStyleName(styleName);
        } else {
            StyleImpl defaultStyle = layer.getDefaultStyle();
            if (defaultStyle != null) {
                this.setStyleName(defaultStyle.getName());
            }
        }
        this.setType(type);
        this.setMatrixSet(tileMatrixSet);
    }

    private static double[] buildScaleList(TileMatrixSet tileMatrixSet) {
        double[] scaleList = new double[tileMatrixSet.size()];
        int j = 0;
        for (TileMatrix tm : tileMatrixSet.getMatrices()) {
            scaleList[j++] = tm.getDenominator();
        }
        return scaleList;
    }

    protected ReferencedEnvelope getReqExtentInTileCrs(ReferencedEnvelope requestedExtent) {
        boolean sameCRS;
        CoordinateReferenceSystem tileCrs;
        CoordinateReferenceSystem reqCrs = requestedExtent.getCoordinateReferenceSystem();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("orig request bbox :" + requestedExtent + " " + reqCrs.getCoordinateSystem().getAxis(0).getDirection() + " (" + reqCrs.getName() + ")");
        }
        ReferencedEnvelope reqExtentInTileCrs = null;
        for (CRSEnvelope layerEnv : this.layer.getLayerBoundingBoxes()) {
            if (CRS.equalsIgnoreMetadata((Object)reqCrs, (Object)layerEnv.getCoordinateReferenceSystem())) {
                requestedExtent = requestedExtent.intersection((Envelope)new ReferencedEnvelope((org.opengis.geometry.Envelope)layerEnv));
                if (!LOGGER.isLoggable(Level.FINE)) break;
                LOGGER.fine("Layer CRS match: cropping request bbox :" + requestedExtent);
                break;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Layer CRS not matching: req:" + reqCrs.getName() + " cov:" + layerEnv.getCoordinateReferenceSystem().getName());
        }
        if (!CRS.equalsIgnoreMetadata((Object)(tileCrs = this.matrixSet.getCoordinateReferenceSystem()), (Object)requestedExtent.getCoordinateReferenceSystem())) {
            try {
                reqExtentInTileCrs = requestedExtent.transform(tileCrs, true);
            }
            catch (FactoryException | TransformException ex) {
                LOGGER.log(Level.WARNING, "Requested extent can't be projected to tile CRS (" + reqCrs.getCoordinateSystem().getName() + " -> " + tileCrs.getCoordinateSystem().getName() + ") :" + ex.getMessage());
                try {
                    ReferencedEnvelope covExtentInReqCrs = this.envelope.transform(reqCrs, true);
                    requestedExtent = requestedExtent.intersection((Envelope)covExtentInReqCrs);
                }
                catch (FactoryException | TransformException ex2) {
                    LOGGER.log(Level.WARNING, "Incompatible CRS: " + ex2.getMessage());
                    return null;
                }
            }
        } else {
            reqExtentInTileCrs = requestedExtent;
        }
        if (reqExtentInTileCrs == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Requested extent not in tile CRS range");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "tile crs req bbox :" + reqExtentInTileCrs + " " + reqExtentInTileCrs.getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getDirection() + " (" + reqExtentInTileCrs.getCoordinateReferenceSystem().getName() + ")");
        }
        ReferencedEnvelope coverageEnvelope = this.getBounds();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "coverage bbox :" + coverageEnvelope + " " + coverageEnvelope.getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getDirection() + " (" + coverageEnvelope.getCoordinateReferenceSystem().getName() + ")");
        }
        if (sameCRS = CRS.equalsIgnoreMetadata((Object)coverageEnvelope.getCoordinateReferenceSystem(), (Object)reqExtentInTileCrs.getCoordinateReferenceSystem())) {
            if (!coverageEnvelope.intersects((BoundingBox)reqExtentInTileCrs)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Extents do not intersect (sameCRS))");
                }
                return null;
            }
        } else {
            try {
                ReferencedEnvelope dataEnvelopeWGS84 = coverageEnvelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                ReferencedEnvelope requestEnvelopeWGS84 = requestedExtent.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                if (!dataEnvelopeWGS84.intersects((BoundingBox)requestEnvelopeWGS84)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Extents do not intersect");
                    }
                    return null;
                }
            }
            catch (FactoryException | TransformException e) {
                throw new RuntimeException(e);
            }
        }
        return reqExtentInTileCrs;
    }

    /*
     * Unable to fully structure code
     */
    public Set<Tile> findTilesInExtent(ReferencedEnvelope requestedExtent, double scaleFactor, boolean recommendedZoomLevel, int maxNumberOfTiles) {
        ret = Collections.emptySet();
        reqExtentInTileCrs = this.getReqExtentInTileCrs(requestedExtent);
        if (reqExtentInTileCrs == null) {
            if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
                WMTSTileService.LOGGER.log(Level.FINE, "No valid extents, no Tiles will be returned.");
            }
            return ret;
        }
        tileFactory = (WMTSTileFactory)this.getTileFactory();
        zoomLevelMatcher = null;
        try {
            zoomLevelMatcher = this.getZoomLevelMatcher(reqExtentInTileCrs, this.matrixSet.getCoordinateReferenceSystem(), scaleFactor);
        }
        catch (FactoryException | TransformException e) {
            throw new RuntimeException(e);
        }
        zl = this.getZoomLevelFromMapScale(zoomLevelMatcher, scaleFactor);
        zoomLevel = tileFactory.getZoomLevel(zl, this);
        maxNumberOfTilesForZoomLevel = zoomLevel.getMaxTileNumber();
        if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
            WMTSTileService.LOGGER.log(Level.FINE, "Zoom level:" + zl + "[" + zoomLevel.getMaxTilePerColNumber() + " x " + zoomLevel.getMaxTilePerRowNumber() + "]");
        }
        tileList = new HashSet<Tile>((int)Math.min((long)maxNumberOfTiles, maxNumberOfTilesForZoomLevel));
        aorder = CRS.getAxisOrder((CoordinateReferenceSystem)reqExtentInTileCrs.getCoordinateReferenceSystem());
        switch (2.$SwitchMap$org$geotools$referencing$CRS$AxisOrder[aorder.ordinal()]) {
            case 1: {
                ulLon = reqExtentInTileCrs.getMinX();
                ulLat = reqExtentInTileCrs.getMaxY();
                break;
            }
            case 2: {
                if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
                    WMTSTileService.LOGGER.log(Level.FINE, "Inverted tile coords!");
                }
                ulLon = reqExtentInTileCrs.getMinY();
                ulLat = reqExtentInTileCrs.getMaxX();
                break;
            }
            default: {
                WMTSTileService.LOGGER.log(Level.WARNING, "unexpected axis order " + aorder);
                return ret;
            }
        }
        firstTile = tileFactory.findUpperLeftTile(ulLon, ulLat, zoomLevel, this);
        if (firstTile == null) {
            if (WMTSTileService.LOGGER.isLoggable(Level.INFO)) {
                WMTSTileService.LOGGER.log(Level.INFO, "First tile not available at x:" + reqExtentInTileCrs.getMinX() + " y:" + reqExtentInTileCrs.getMaxY() + " at " + (Object)zoomLevel);
            }
            return ret;
        }
        if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
            WMTSTileService.LOGGER.log(Level.FINE, "Adding first tile " + firstTile.getId() + " " + firstTile.getExtent() + " (" + firstTile.getExtent().getCoordinateReferenceSystem().getName() + ")");
        }
        this.addTileToCache(firstTile);
        tileList.add(firstTile);
        firstTileOfRow = firstTile;
        movingTile = firstTile;
        do lbl-1000:
        // 3 sources

        {
            block23: {
                block24: {
                    block22: {
                        if ((rightNeighbour = tileFactory.findRightNeighbour(movingTile, this)) != null) break block22;
                        if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
                            WMTSTileService.LOGGER.log(Level.FINE, "No tiles on the right of " + movingTile.getId());
                        }
                        break block23;
                    }
                    intersects = reqExtentInTileCrs.intersects((Envelope)rightNeighbour.getExtent());
                    if (intersects) break block24;
                    if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
                        WMTSTileService.LOGGER.log(Level.FINE, "Right neighbour out of extents " + rightNeighbour.getId());
                    }
                    break block23;
                }
                if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
                    WMTSTileService.LOGGER.log(Level.FINE, "Adding right neighbour " + rightNeighbour.getId());
                }
                this.addTileToCache(rightNeighbour);
                tileList.add(rightNeighbour);
                movingTile = rightNeighbour;
                if (tileList.size() > maxNumberOfTiles) {
                    WMTSTileService.LOGGER.warning("Reached tile limit of " + maxNumberOfTiles + ". Returning the tiles collected so far.");
                    return tileList;
                }
                if ((long)tileList.size() < maxNumberOfTilesForZoomLevel) ** GOTO lbl-1000
            }
            if ((lowerNeighbour = tileFactory.findLowerNeighbour(firstTileOfRow, this)) == null) {
                if (!WMTSTileService.LOGGER.isLoggable(Level.FINE)) break;
                WMTSTileService.LOGGER.log(Level.FINE, "No more tiles below " + firstTileOfRow.getId());
                break;
            }
            intersects = reqExtentInTileCrs.intersects((Envelope)lowerNeighbour.getExtent());
            if (intersects) {
                if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
                    WMTSTileService.LOGGER.log(Level.FINE, "Adding lower neighbour " + lowerNeighbour.getId());
                }
            } else {
                if (!WMTSTileService.LOGGER.isLoggable(Level.FINE)) break;
                WMTSTileService.LOGGER.log(Level.FINE, "Lower neighbour out of extents" + lowerNeighbour.getId());
                break;
            }
            this.addTileToCache(lowerNeighbour);
            tileList.add(lowerNeighbour);
            firstTileOfRow = movingTile = lowerNeighbour;
        } while ((long)tileList.size() < maxNumberOfTilesForZoomLevel);
        return tileList;
    }

    protected Tile addTileToCache(Tile tile) {
        return super.addTileToCache(tile);
    }

    public WMTSServiceType getType() {
        return this.type;
    }

    public void setType(WMTSServiceType type) {
        this.type = type;
    }

    private void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public double[] getScaleList() {
        return this.scaleList;
    }

    public ReferencedEnvelope getBounds() {
        return this.envelope;
    }

    public CoordinateReferenceSystem getProjectedTileCrs() {
        return this.matrixSet.getCoordinateReferenceSystem();
    }

    public TileFactory getTileFactory() {
        return tileFactory;
    }

    public String getTileMatrixSetName() {
        return this.tileMatrixSetName;
    }

    public void setTileMatrixSetName(String tileMatrixSetName) {
        if (tileMatrixSetName == null || tileMatrixSetName.isEmpty()) {
            throw new IllegalArgumentException("Tile matrix set name cannot be null");
        }
        this.tileMatrixSetName = tileMatrixSetName;
    }

    public TileMatrixSetLink getMatrixSetLink() {
        return this.layer.getTileMatrixLinks().get(this.tileMatrixSetName);
    }

    public String getTemplateURL() {
        return this.templateURL;
    }

    public void setTemplateURL(String templateURL) {
        this.templateURL = templateURL;
    }

    public TileMatrix getTileMatrix(int zoomLevel) {
        if (this.matrixSet == null) {
            throw new RuntimeException("TileMatrix is not set in WMTSService");
        }
        return this.matrixSet.getMatrices().get(zoomLevel);
    }

    public TileMatrixSet getMatrixSet() {
        return this.matrixSet;
    }

    public void setMatrixSet(TileMatrixSet matrixSet) {
        this.matrixSet = matrixSet;
        this.scaleList = new double[matrixSet.size()];
        int j = 0;
        for (TileMatrix tm : matrixSet.getMatrices()) {
            this.scaleList[j++] = tm.getDenominator();
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public WMTSZoomLevel getZoomLevel(int zoom) {
        return new WMTSZoomLevel(zoom, this);
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public Map<String, Object> getExtrainfo() {
        return this.extrainfo;
    }

    private ScaleZoomLevelMatcher getZoomLevelMatcher(ReferencedEnvelope requestExtent, CoordinateReferenceSystem crsTiles, double scale) throws FactoryException, TransformException {
        CoordinateReferenceSystem crsMap = requestExtent.getCoordinateReferenceSystem();
        MathTransform transformMapToTile = CRS.findMathTransform((CoordinateReferenceSystem)crsMap, (CoordinateReferenceSystem)crsTiles);
        MathTransform transformTileToMap = CRS.findMathTransform((CoordinateReferenceSystem)crsTiles, (CoordinateReferenceSystem)crsMap);
        ReferencedEnvelope mapExtentTileCrs = ScaleZoomLevelMatcher.getProjectedEnvelope((ReferencedEnvelope)requestExtent, (CoordinateReferenceSystem)crsTiles, (MathTransform)transformMapToTile);
        return new ScaleZoomLevelMatcher(crsMap, crsTiles, transformMapToTile, transformTileToMap, mapExtentTileCrs, requestExtent, scale){

            public int getZoomLevelFromScale(TileService service, double[] tempScaleList) {
                double min = Double.MAX_VALUE;
                double scaleFactor = this.getScale();
                int zoomLevel = 0;
                for (int i = WMTSTileService.this.scaleList.length - 1; i >= 0; --i) {
                    double v = WMTSTileService.this.scaleList[i];
                    double diff = Math.abs(v - scaleFactor);
                    if (!(diff < min)) continue;
                    min = diff;
                    zoomLevel = i;
                }
                return zoomLevel;
            }
        };
    }
}

