/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.client;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.ows.HTTPClient;
import org.geotools.image.io.ImageIOExt;
import org.geotools.ows.wmts.client.WMTSTileFactory;
import org.geotools.ows.wmts.client.WMTSTileIdentifier;
import org.geotools.ows.wmts.client.WMTSTileService;
import org.geotools.ows.wmts.model.WMTSServiceType;
import org.geotools.tile.Tile;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.util.ObjectCache;
import org.geotools.util.ObjectCaches;
import org.geotools.util.logging.Logging;

class WMTSTile
extends Tile {
    protected static final Logger LOGGER = Logging.getLogger(WMTSTile.class);
    public static final String WMTS_TILE_CACHE_SIZE_PROPERTY_NAME = "wmts.tile.cache.size";
    private static final ObjectCache tileImages;
    private final WMTSServiceType type;
    private final WMTSTileService service;

    public WMTSTile(int x, int y, ZoomLevel zoomLevel, TileService service) {
        this(new WMTSTileIdentifier(x, y, zoomLevel, service.getName()), service);
    }

    public WMTSTile(WMTSTileIdentifier tileIdentifier, TileService service) {
        super((TileIdentifier)tileIdentifier, WMTSTileFactory.getExtentFromTileName(tileIdentifier, service), ((WMTSTileService)service).getTileMatrix(tileIdentifier.getZoomLevel().getZoomLevel()).getTileWidth());
        this.service = (WMTSTileService)service;
        this.type = this.service.getType();
    }

    public WMTSServiceType getType() {
        return this.type;
    }

    public URL getUrl() {
        String baseUrl = this.service.getTemplateURL();
        TileIdentifier tileIdentifier = this.getTileIdentifier();
        if (null == this.type) {
            throw new IllegalArgumentException("Unexpected WMTS Service type " + (Object)((Object)this.type));
        }
        switch (this.type) {
            case KVP: {
                return this.getKVPurl(baseUrl, tileIdentifier);
            }
            case REST: {
                return this.getRESTurl(baseUrl, tileIdentifier);
            }
        }
        throw new IllegalArgumentException("Unexpected WMTS Service type " + (Object)((Object)this.type));
    }

    private URL getRESTurl(String baseUrl, TileIdentifier tileIdentifier) throws RuntimeException {
        String tileMatrix = this.service.getTileMatrix(tileIdentifier.getZ()).getIdentifier();
        if (baseUrl.indexOf("{style}") != -1) {
            baseUrl = baseUrl.replace("{style}", this.service.getStyleName());
        } else if (baseUrl.indexOf("{Style}") != -1) {
            baseUrl = baseUrl.replace("{Style}", this.service.getStyleName());
        }
        baseUrl = baseUrl.replace("{TileMatrixSet}", this.service.getTileMatrixSetName());
        baseUrl = baseUrl.replace("{TileMatrix}", "" + tileMatrix);
        baseUrl = baseUrl.replace("{TileCol}", "" + tileIdentifier.getX());
        baseUrl = baseUrl.replace("{TileRow}", "" + tileIdentifier.getY());
        baseUrl = this.replaceToken(baseUrl, "time", this.service.getDimensions().get("time"));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Requesting tile " + tileIdentifier.getCode());
        }
        try {
            return new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private String replaceToken(String base, String dimName, String dimValue) {
        String token = "{" + dimName + "}";
        int index = base.toLowerCase().indexOf(token.toLowerCase());
        if (index != -1) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Resolving dimension " + dimName + " --> " + dimValue);
            }
            return base.substring(0, index) + dimValue + base.substring(index + dimName.length() + 2);
        }
        return base;
    }

    private URL getKVPurl(String baseUrl, TileIdentifier tileIdentifier) throws RuntimeException {
        if (!baseUrl.contains("?")) {
            baseUrl = baseUrl + "?";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("service", "WMTS");
        params.put("version", "1.0.0");
        params.put("request", "GetTile");
        params.put("layer", this.service.getLayerName());
        params.put("style", this.service.getStyleName());
        params.put("format", this.service.getFormat());
        params.put("tilematrixset", this.service.getTileMatrixSetName());
        params.put("TileMatrix", this.service.getTileMatrix(tileIdentifier.getZ()).getIdentifier());
        params.put("TileCol", tileIdentifier.getX());
        params.put("TileRow", tileIdentifier.getY());
        StringBuilder arguments = new StringBuilder();
        for (String key : params.keySet()) {
            Object val = params.get(key);
            try {
                if (val == null) continue;
                arguments.append(key).append("=");
                arguments.append(URLEncoder.encode(val.toString(), "UTF-8"));
                arguments.append('&');
            }
            catch (Exception e) {
                LOGGER.warning("Could not encode param '" + key + "' with value '" + val + "'");
            }
        }
        try {
            return new URL(baseUrl + arguments.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public BufferedImage loadImageTileImage(Tile tile) throws IOException {
        LOGGER.log(Level.FINE, "Loading tile " + this.getId() + ": " + this.getUrl());
        String tileKey = tile.getUrl().toString();
        if (tileImages.peek((Object)tileKey) != null && tileImages.get((Object)tileKey) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Tile image already loaded for tile " + this.getId());
            }
            return (BufferedImage)tileImages.get((Object)tileKey);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Tile image not yet loaded for tile " + this.getId());
        }
        BufferedImage bi = this.doLoadImageTileImage(tile);
        tileImages.put((Object)tileKey, (Object)bi);
        return bi;
    }

    public BufferedImage doLoadImageTileImage(Tile tile) throws IOException {
        Map headers = (Map)this.service.getExtrainfo().get("HEADERS");
        try (InputStream is = this.setupInputStream(this.getUrl(), headers);){
            BufferedImage bufferedImage = ImageIOExt.readBufferedImage((Object)is);
            return bufferedImage;
        }
    }

    private InputStream setupInputStream(URL url, Map<String, String> headers) throws IOException {
        HTTPClient client = this.service.getHttpClient();
        return client.get(url, headers).getResponseStream();
    }

    static {
        int cacheSize = 150;
        String size = System.getProperty(WMTS_TILE_CACHE_SIZE_PROPERTY_NAME);
        if (size != null) {
            try {
                cacheSize = Integer.parseUnsignedInt(size);
            }
            catch (NumberFormatException ex) {
                LOGGER.info("Bad wmts.tile.cache.size property '" + size + "'");
            }
        }
        tileImages = ObjectCaches.create((String)"soft", (int)cacheSize);
    }
}

