/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.data.ows.AbstractGetCapabilitiesRequest;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.Response;
import org.geotools.data.ows.SimpleHttpClient;
import org.geotools.data.ows.Specification;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wmts.model.WMTSCapabilities;
import org.geotools.ows.wmts.model.WMTSServiceType;
import org.geotools.ows.wmts.request.AbstractGetTileRequest;
import org.geotools.ows.wmts.response.GetTileResponse;
import org.geotools.ows.wmts.response.WMTSGetCapabilitiesResponse;

public class WMTSSpecification
extends Specification {
    public static final String WMTS_VERSION = "1.0.0";
    private WMTSServiceType type;
    static Set<String> keywords = new TreeSet<String>();

    public String getVersion() {
        return WMTS_VERSION;
    }

    public GetCapabilitiesRequest createGetCapabilitiesRequest(URL server) {
        return new GetCapsRequest(server);
    }

    public GetTileRequest createGetTileRequest(URL server, Properties props, WMTSCapabilities caps) {
        return this.createGetTileRequest(server, props, caps, (HTTPClient)new SimpleHttpClient());
    }

    public GetTileRequest createGetTileRequest(URL server, Properties props, WMTSCapabilities caps, HTTPClient client) {
        return new GetTileRequest(server, props, caps, client);
    }

    public static String processKey(String key) {
        if (keywords.contains(key.toLowerCase())) {
            return key.trim().toUpperCase();
        }
        return key;
    }

    static {
        String[] words = new String[]{"request", "version", "layer", "acceptversions", "sections", "updatesequence", "acceptformats", "style", "format", "tilematrixset", "tilematrix", "tilerow", "tilecol", "j", "i", "infoformat", "service", "time", "elevation", "band"};
        keywords.addAll(Arrays.asList(words));
    }

    public static class GetCapsRequest
    extends AbstractGetCapabilitiesRequest {
        public GetCapsRequest(URL urlGetCapabilities) {
            super(urlGetCapabilities);
        }

        protected void initService() {
            this.setProperty("SERVICE", "WMTS");
        }

        protected void initVersion() {
            this.setProperty("VERSION", WMTSSpecification.WMTS_VERSION);
        }

        protected String processKey(String key) {
            return WMTSSpecification.processKey(key);
        }

        public WMTSGetCapabilitiesResponse createResponse(HTTPResponse httpResponse) throws ServiceException, IOException {
            return new WMTSGetCapabilitiesResponse(httpResponse, this.hints);
        }
    }

    public static class GetTileRequest
    extends AbstractGetTileRequest {
        public GetTileRequest(URL onlineResource, Properties properties, WMTSCapabilities capabilities) {
            this(onlineResource, properties, capabilities, (HTTPClient)new SimpleHttpClient());
        }

        public GetTileRequest(URL onlineResource, Properties properties, WMTSCapabilities capabilities, HTTPClient client) {
            super(onlineResource, properties, client);
            if (properties.containsKey("type")) {
                String t = (String)properties.get("type");
                if ("REST".equalsIgnoreCase(t)) {
                    this.type = WMTSServiceType.REST;
                } else if ("KVP".equalsIgnoreCase(t)) {
                    this.type = WMTSServiceType.KVP;
                }
            } else {
                this.type = capabilities.getType();
            }
            this.capabilities = capabilities;
        }

        @Override
        public Response createResponse(HTTPResponse response) throws ServiceException, IOException {
            return new GetTileResponse(response, this.getType());
        }

        @Override
        protected void initVersion() {
            this.setProperty("VERSION", WMTSSpecification.WMTS_VERSION);
        }

        public WMTSServiceType getType() {
            return this.type;
        }

        public void setType(WMTSServiceType type) {
            this.type = type;
        }
    }
}

