/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

class TileURLBuilder {
    private static Logger LOGGER = Logging.getLogger(TileURLBuilder.class);
    private static final String TILEMATRIX = "{tilematrix}";
    private static final String TILECOL = "{tilecol}";
    private static final String TILEROW = "{tilerow}";
    private static final int MATRIX = 0;
    private static final int COL = 1;
    private static final int ROW = 2;
    private int[] indexes = new int[3];
    private ArrayList<Part> parts;
    private int start = 0;
    private String templateURL;
    private int urlLength = 50;

    TileURLBuilder(String templateURL) {
        if (templateURL == null) {
            throw new IllegalArgumentException("templateURL cannot be null");
        }
        String lowerTemplate = templateURL.toLowerCase();
        this.indexes[0] = lowerTemplate.indexOf(TILEMATRIX);
        this.indexes[1] = lowerTemplate.indexOf(TILECOL);
        this.indexes[2] = lowerTemplate.indexOf(TILEROW);
        this.parts = new ArrayList(7);
        this.templateURL = templateURL;
        if (this.indexes[0] < this.indexes[1] && this.indexes[0] < this.indexes[2]) {
            this.addMatrixParts();
            if (this.indexes[1] < this.indexes[2]) {
                this.addColParts();
                this.addRowParts();
            } else {
                this.addRowParts();
                this.addColParts();
            }
        } else if (this.indexes[1] < this.indexes[2]) {
            this.addColParts();
            if (this.indexes[0] < this.indexes[2]) {
                this.addMatrixParts();
                this.addRowParts();
            } else {
                this.addRowParts();
                this.addMatrixParts();
            }
        } else {
            this.addRowParts();
            if (this.indexes[0] < this.indexes[1]) {
                this.addMatrixParts();
                this.addColParts();
            } else {
                this.addColParts();
                this.addMatrixParts();
            }
        }
        this.addStringPart(templateURL.length(), 0);
    }

    String createURL(String tileMatrix, int tileCol, int tileRow) {
        StringBuilder builder = new StringBuilder(this.urlLength);
        try {
            String encodedtileMatrix = URLEncoder.encode(tileMatrix, "UTF-8");
            this.parts.forEach(part -> part.append(builder, encodedtileMatrix, tileCol, tileRow));
            String url = builder.toString();
            this.urlLength = Math.max(this.urlLength, url.length());
            return url;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Didn't support UTF-8", e);
        }
    }

    private void addColParts() {
        if (this.indexes[1] == -1) {
            LOGGER.info("WMTSTileService templateURL doesn't contain {TileCol}");
            return;
        }
        this.addStringPart(this.indexes[1], TILECOL.length());
        this.parts.add((builder, matrix, col, row) -> builder.append(col));
    }

    private void addRowParts() {
        if (this.indexes[2] == -1) {
            LOGGER.info("WMTSTileService templateURL doesn't contain {TileRow}");
            return;
        }
        this.addStringPart(this.indexes[2], TILEROW.length());
        this.parts.add((builder, matrix, col, row) -> builder.append(row));
    }

    private void addMatrixParts() {
        if (this.indexes[0] == -1) {
            LOGGER.info("WMTSTileService templateURL doesn't contain {TileMatrix}");
            return;
        }
        this.addStringPart(this.indexes[0], TILEMATRIX.length());
        this.parts.add((builder, matrix, col, row) -> builder.append(matrix));
    }

    private void addStringPart(int end, int length) {
        if (end < this.start) {
            throw new IllegalArgumentException("end can't be smaller than start.");
        }
        if (this.start < end) {
            String part = this.templateURL.substring(this.start, end);
            this.parts.add((builder, matrix, col, row) -> builder.append(part));
            this.start = end + length;
        }
    }

    static interface Part {
        public void append(StringBuilder var1, String var2, int var3, int var4);
    }
}

