/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wms.request;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.request.AbstractWMSRequest;
import org.geotools.ows.wms.request.GetFeatureInfoRequest;
import org.geotools.ows.wms.request.GetMapRequest;

public abstract class AbstractGetFeatureInfoRequest
extends AbstractWMSRequest
implements GetFeatureInfoRequest {
    private Set queryLayers = new TreeSet();

    public AbstractGetFeatureInfoRequest(URL onlineResource, GetMapRequest request) {
        super(onlineResource, AbstractGetFeatureInfoRequest.getMapProperties(request));
    }

    static Properties getMapProperties(GetMapRequest request) {
        request.getFinalURL();
        return request.getProperties();
    }

    public URL getFinalURL() {
        String queryLayerString;
        Iterator iter = this.queryLayers.iterator();
        String initialQueryLayerString = this.properties.getProperty("QUERY_LAYERS") == null ? "" : this.properties.getProperty("QUERY_LAYERS");
        String string = queryLayerString = this.properties.getProperty("QUERY_LAYERS") == null ? "" : this.properties.getProperty("QUERY_LAYERS");
        while (iter.hasNext()) {
            Layer layer = (Layer)iter.next();
            try {
                queryLayerString = queryLayerString + URLEncoder.encode(layer.getName(), "UTF-8").replaceAll("\\+", "%20");
            }
            catch (UnsupportedEncodingException | NullPointerException e) {
                queryLayerString = queryLayerString + layer.getName();
            }
            if (!iter.hasNext()) continue;
            queryLayerString = queryLayerString + ",";
        }
        this.setProperty("QUERY_LAYERS", queryLayerString);
        URL url = super.getFinalURL();
        this.setProperty("QUERY_LAYERS", initialQueryLayerString);
        return url;
    }

    @Override
    public void addQueryLayer(Layer layer) {
        this.queryLayers.add(layer);
    }

    @Override
    public void setQueryLayers(Set layers) {
        this.queryLayers = layers;
    }

    @Override
    public void setInfoFormat(String infoFormat) {
        this.setProperty("INFO_FORMAT", infoFormat);
    }

    @Override
    public void setFeatureCount(String featureCount) {
        this.setProperty("FEATURE_COUNT", featureCount);
    }

    @Override
    public void setFeatureCount(int featureCount) {
        this.setFeatureCount(Integer.toString(featureCount));
    }

    @Override
    public void setQueryPoint(int x, int y) {
        this.setProperty(this.getQueryX(), Integer.toString(x));
        this.setProperty(this.getQueryY(), Integer.toString(y));
    }

    protected String getQueryX() {
        return "X";
    }

    protected String getQueryY() {
        return "Y";
    }

    protected void initRequest() {
        this.setProperty("REQUEST", "feature_info");
    }

    protected abstract void initVersion();
}

