/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.ows.Capabilities;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WMSRequest;

public class WMSCapabilities
extends Capabilities {
    private WMSRequest request;
    private Layer layer;
    private List<Layer> layers;
    private String[] exceptions;

    public Layer getLayer() {
        return this.layer;
    }

    public void setVersion(String version) {
        boolean forceXY;
        super.setVersion(version);
        boolean bl = forceXY = !this.getVersion().startsWith("1.3");
        if (this.layer != null) {
            WMSCapabilities.fixLayerBoundingBox(this.layer, forceXY);
            this.layer.clearCache();
        }
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
        if (this.getVersion() != null) {
            boolean forceXY = !this.getVersion().startsWith("1.3");
            WMSCapabilities.fixLayerBoundingBox(layer, forceXY);
            layer.clearCache();
        }
    }

    static void fixLayerBoundingBox(Layer layer, boolean forceXY) {
        if (layer == null) {
            return;
        }
        if (layer.getLayerBoundingBoxes() != null) {
            for (CRSEnvelope boundingBox : layer.getLayerBoundingBoxes()) {
                String srsName = boundingBox.getSRSName();
                boundingBox.setSRSName(srsName, forceXY);
            }
        }
        for (Layer child : layer.getChildren()) {
            WMSCapabilities.fixLayerBoundingBox(child, forceXY);
        }
    }

    public List<Layer> getLayerList() {
        if (this.layers == null) {
            this.layers = new ArrayList<Layer>();
            this.layers.add(this.layer);
            this.addChildrenRecursive(this.layers, this.layer);
        }
        return Collections.unmodifiableList(this.layers);
    }

    private void addChildrenRecursive(List<Layer> layers, Layer layer) {
        if (layer.getChildren() != null) {
            for (Layer child : layer.getChildren()) {
                layers.add(child);
                this.addChildrenRecursive(layers, child);
            }
        }
    }

    public WMSRequest getRequest() {
        return this.request;
    }

    public void setRequest(WMSRequest request) {
        this.request = request;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(String[] exceptions) {
        this.exceptions = exceptions;
    }
}

