/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WMSCapabilities;
import org.geotools.referencing.CRS;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class WMSUtils {
    private static Map<CoordinateReferenceSystem, Set<String>> crsCache = new HashMap<CoordinateReferenceSystem, Set<String>>();

    public static Layer[] getNamedLayers(WMSCapabilities capabilities) {
        Layer[] layers;
        if (capabilities == null) {
            return null;
        }
        ArrayList<Layer> namedLayersList = new ArrayList<Layer>();
        for (Layer layer : layers = capabilities.getLayerList().toArray(new Layer[capabilities.getLayerList().size()])) {
            if (layer.getName() == null || layer.getName().length() == 0) continue;
            namedLayersList.add(layer);
        }
        Layer[] namedLayers = new Layer[namedLayersList.size()];
        for (int i = 0; i < namedLayersList.size(); ++i) {
            namedLayers[i] = (Layer)namedLayersList.get(i);
        }
        return namedLayers;
    }

    public static Set getQueryableLayers(WMSCapabilities capabilities) {
        Layer[] namedLayers;
        TreeSet<Layer> layers = new TreeSet<Layer>();
        for (Layer layer : namedLayers = WMSUtils.getNamedLayers(capabilities)) {
            if (!layer.isQueryable()) continue;
            layers.add(layer);
        }
        return layers;
    }

    public static Set getSRSs(WMSCapabilities capabilities) {
        Layer[] layers;
        TreeSet<String> srss = new TreeSet<String>();
        for (Layer layer : layers = capabilities.getLayerList().toArray(new Layer[capabilities.getLayerList().size()])) {
            if (layer.getSrs() == null) continue;
            srss.addAll(layer.getSrs());
        }
        return srss;
    }

    public static Set<String> findCommonEPSGs(List layers) {
        TreeSet<String> set = new TreeSet<String>();
        Layer first = (Layer)layers.get(0);
        set.addAll(first.getSrs());
        for (int i = 1; i < layers.size(); ++i) {
            Layer layer = (Layer)layers.get(i);
            set.retainAll(layer.getSrs());
        }
        return set;
    }

    public static String matchEPSG(CoordinateReferenceSystem crs, Set codes) {
        TreeSet previous = (TreeSet)crsCache.get(crs);
        if (previous != null) {
            for (String code : previous) {
                if (!codes.contains(code)) continue;
                return code;
            }
        }
        for (Identifier ident : crs.getIdentifiers()) {
            String epsgCode = ident.toString();
            if (!codes.contains(epsgCode)) continue;
            if (crsCache.get(crs) == null) {
                crsCache.put(crs, new TreeSet());
            }
            Set<String> set = crsCache.get(crs);
            set.add(epsgCode);
            return epsgCode;
        }
        Iterator iter = null;
        for (String epsgCode : codes) {
            MathTransform transform;
            CoordinateReferenceSystem epsgCRS;
            try {
                epsgCRS = CRS.decode((String)epsgCode);
            }
            catch (Exception e) {
                continue;
            }
            try {
                transform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)epsgCRS, (boolean)true);
            }
            catch (FactoryException e) {
                continue;
            }
            if (!transform.isIdentity()) continue;
            if (crsCache.get(crs) == null) {
                crsCache.put(crs, new TreeSet());
            }
            Set<String> set = crsCache.get(crs);
            set.add(epsgCode);
            return epsgCode;
        }
        return null;
    }
}

