/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureFactory;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.feature.type.PropertyType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.geotools.data.wfs.internal.WFSStrategy;
import org.geotools.data.wfs.internal.parsers.XmlFeatureParser;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexFeatureBuilder;
import org.geotools.feature.LenientFeatureFactoryImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.gml3.GML;

public class XmlComplexFeatureParser
extends XmlFeatureParser<FeatureType, Feature> {
    private final ComplexFeatureBuilder featureBuilder;
    private Map<String, Attribute> discoveredComplexAttributes = new HashMap<String, Attribute>();
    private Map<String, ArrayList<Attribute>> placeholderComplexAttributes = new HashMap<String, ArrayList<Attribute>>();
    private Filter filter;

    public XmlComplexFeatureParser(InputStream getFeatureResponseStream, FeatureType targetType, QName featureDescriptorName) throws IOException {
        super(getFeatureResponseStream, targetType, featureDescriptorName, null);
        this.featureBuilder = new ComplexFeatureBuilder(this.targetType);
    }

    public XmlComplexFeatureParser(InputStream getFeatureResponseStream, FeatureType targetType, QName featureDescriptorName, Filter filter) throws IOException {
        super(getFeatureResponseStream, targetType, featureDescriptorName, null);
        this.featureBuilder = new ComplexFeatureBuilder(this.targetType);
        this.filter = filter;
    }

    public XmlComplexFeatureParser(InputStream getFeatureResponseStream, FeatureType targetType, QName featureDescriptorName, Filter filter, WFSStrategy strategy) throws IOException {
        super(getFeatureResponseStream, targetType, featureDescriptorName, strategy);
        this.featureBuilder = new ComplexFeatureBuilder(this.targetType);
        this.filter = filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public Feature parse() throws IOException {
        String fid;
        try {
            ReturnAttribute nextAttribute;
            fid = this.seekFeature();
            if (fid == null) {
                return null;
            }
            while ((nextAttribute = this.parseNextAttribute((ComplexType)this.targetType)) != null) {
                if (!Property.class.isAssignableFrom(nextAttribute.value.getClass())) {
                    this.featureBuilder.append(nextAttribute.name, (Property)new AttributeImpl(nextAttribute.value, (AttributeDescriptor)this.targetType.getDescriptor(nextAttribute.name), null));
                    continue;
                }
                this.featureBuilder.append(nextAttribute.name, (Property)nextAttribute.value);
            }
        }
        catch (XMLStreamException e) {
            throw new DataSourceException((Throwable)e);
        }
        Feature feature = this.featureBuilder.buildFeature(fid);
        if (this.filter == null || this.filter.evaluate((Object)feature)) {
            return feature;
        }
        return null;
    }

    private void registerGmlTarget(String id, Attribute value) {
        this.discoveredComplexAttributes.put(id, value);
        if (this.placeholderComplexAttributes.containsKey(id)) {
            for (Attribute placeholderComplexAttribute : this.placeholderComplexAttributes.get(id)) {
                placeholderComplexAttribute.setValue(value.getValue());
            }
        }
    }

    private Attribute resolveHref(String href, AttributeDescriptor expectedDescriptor) {
        if (href.startsWith("#")) {
            String hrefId = href.substring(1);
            if (this.discoveredComplexAttributes.containsKey(hrefId)) {
                return this.discoveredComplexAttributes.get(hrefId);
            }
            AttributeImpl placeholderComplexAttribute = new AttributeImpl(Collections.emptyList(), expectedDescriptor, null);
            if (!this.placeholderComplexAttributes.containsKey(hrefId)) {
                this.placeholderComplexAttributes.put(hrefId, new ArrayList());
            }
            this.placeholderComplexAttributes.get(hrefId).add((Attribute)placeholderComplexAttribute);
            return placeholderComplexAttribute;
        }
        AttributeImpl placeholderComplexAttribute = new AttributeImpl(Collections.emptyList(), expectedDescriptor, null);
        return placeholderComplexAttribute;
    }

    static AttributeType getSimpleContentType(AttributeType type) {
        Class binding = type.getBinding();
        if (binding == Collection.class) {
            return XmlComplexFeatureParser.getSimpleContentType(type.getSuper());
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ReturnAttribute parseNextAttribute(ComplexType complexType) throws XMLStreamException, IOException {
        int tagType;
        while ((tagType = this.parser.next()) != 1 && tagType != 2 && tagType != 8) {
        }
        if (tagType == 1) {
            NameImpl currentTagName = new NameImpl(this.parser.getNamespaceURI(), this.parser.getLocalName());
            PropertyDescriptor descriptor = complexType.getDescriptor((Name)currentTagName);
            if (descriptor == null) throw new RuntimeException(String.format("WFS response structure unexpected. Could not find descriptor in type '%s' for '%s'.", complexType, currentTagName));
            PropertyType type = descriptor.getType();
            String id = this.parser.getAttributeValue(GML.id.getNamespaceURI(), GML.id.getLocalPart());
            String href = this.parser.getAttributeValue("http://www.w3.org/1999/xlink", "href");
            if (href != null) {
                Attribute hrefAttribute = this.resolveHref(href, (AttributeDescriptor)descriptor);
                while (this.parser.next() != 2) {
                }
                return new ReturnAttribute(id, (Name)currentTagName, hrefAttribute);
            }
            if (type instanceof ComplexType) {
                ReturnAttribute innerAttribute;
                AttributeBuilder attributeBuilder = new AttributeBuilder((FeatureFactory)new LenientFeatureFactoryImpl());
                attributeBuilder.setDescriptor((AttributeDescriptor)descriptor);
                if (type.getBinding() == Collection.class && Types.isSimpleContentType((PropertyType)type)) {
                    this.parser.next();
                    String value = this.parser.getText();
                    ArrayList<AttributeImpl> list = new ArrayList<AttributeImpl>();
                    if (value != null || descriptor.isNillable()) {
                        AttributeType simpleContentType = XmlComplexFeatureParser.getSimpleContentType((AttributeType)type);
                        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
                        Object convertedValue = ff.literal((Object)value).evaluate((Object)value, simpleContentType.getBinding());
                        AttributeDescriptorImpl simpleContentDescriptor = new AttributeDescriptorImpl(simpleContentType, ComplexFeatureConstants.SIMPLE_CONTENT, 1, 1, true, null);
                        list.add(new AttributeImpl(convertedValue, (AttributeDescriptor)simpleContentDescriptor, null));
                    }
                    while (this.parser.next() != 2) {
                    }
                    return new ReturnAttribute(id, (Name)currentTagName, list);
                }
                while ((innerAttribute = this.parseNextAttribute((ComplexType)type)) != null) {
                    if (ComplexAttribute.class.isAssignableFrom(innerAttribute.value.getClass())) {
                        ArrayList<Property> properties = new ArrayList<Property>();
                        properties.add((Property)innerAttribute.value);
                        attributeBuilder.add(innerAttribute.id, properties, innerAttribute.name);
                        continue;
                    }
                    attributeBuilder.add(innerAttribute.id, this.getValue(innerAttribute), innerAttribute.name);
                }
                Attribute attribteValue = type instanceof FeatureType ? attributeBuilder.build(id) : attributeBuilder.build();
                if (id == null) return new ReturnAttribute(id, (Name)currentTagName, attribteValue);
                this.registerGmlTarget(id, attribteValue);
                return new ReturnAttribute(id, (Name)currentTagName, attribteValue);
            }
            if (type instanceof GeometryType) {
                Object attributeValue = super.parseAttributeValue((AttributeDescriptor)descriptor);
                while (this.parser.next() != 2) {
                }
                return new ReturnAttribute(id, (Name)currentTagName, attributeValue);
            }
            if (!(type instanceof AttributeType)) return null;
            Object attributeValue = super.parseAttributeValue((AttributeDescriptor)descriptor);
            return new ReturnAttribute(id, (Name)currentTagName, attributeValue);
        }
        if (tagType != 8) return null;
        this.close();
        return null;
    }

    private Object getValue(ReturnAttribute innerAttribute) {
        if (innerAttribute.value instanceof AttributeImpl) {
            return ((AttributeImpl)innerAttribute.value).getValue();
        }
        return innerAttribute.value;
    }

    private class ReturnAttribute {
        public final String id;
        public final Name name;
        public final Object value;

        public ReturnAttribute(String id, Name name, Object value) {
            this.id = id;
            this.name = name;
            this.value = value;
        }
    }
}

