/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.ows.Response;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.geotools.util.logging.Logging;

public class WFSResponse
extends Response {
    private static final Logger LOGGER = Logging.getLogger(WFSResponse.class);
    private Charset charset;
    private String contentType;
    private WFSRequest request;
    private SimpleFeatureType queryType;
    private QName remoteTypeName;

    public WFSResponse(WFSRequest originatingRequest, HTTPResponse httpResponse) throws ServiceException, IOException {
        super(httpResponse);
        this.request = originatingRequest;
        String charset = httpResponse.getResponseHeader("Charset");
        if (charset == null) {
            this.charset = StandardCharsets.UTF_8;
        } else {
            try {
                this.charset = Charset.forName(charset);
            }
            catch (Exception e) {
                this.charset = StandardCharsets.UTF_8;
            }
        }
        this.contentType = httpResponse.getContentType();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("WFS response: charset=" + charset + ", contentType=" + this.contentType);
        }
    }

    public Charset getCharacterEncoding() {
        return this.charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public WFSRequest getOriginatingRequest() {
        return this.request;
    }

    public String toString() {
        return "WFSResponse[charset=" + this.charset + ", contentType=" + this.contentType + "]";
    }

    public SimpleFeatureType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(SimpleFeatureType queryType) {
        this.queryType = queryType;
    }

    public QName getRemoteTypeName() {
        return this.remoteTypeName;
    }

    public void setRemoteTypeName(QName remoteName) {
        this.remoteTypeName = remoteName;
    }
}

