/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.wfs.internal.DescribeFeatureTypeRequest;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.data.wfs.internal.WFSStrategy;
import org.geotools.data.wfs.internal.parsers.EmfAppSchemaParser;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.geotools.util.URLs;
import org.geotools.xsd.Configuration;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class DescribeFeatureTypeResponse
extends WFSResponse {
    private FeatureType parsed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescribeFeatureTypeResponse(DescribeFeatureTypeRequest request, HTTPResponse httpResponse) throws ServiceException, IOException {
        super(request, httpResponse);
        WFSStrategy strategy = request.getStrategy();
        Configuration wfsConfiguration = strategy.getWfsConfiguration();
        QName remoteTypeName = request.getTypeName();
        FeatureTypeInfo featureTypeInfo = strategy.getFeatureTypeInfo(remoteTypeName);
        CoordinateReferenceSystem defaultCrs = featureTypeInfo.getCRS();
        EntityResolver resolver = request.getStrategy().getConfig().getEntityResolver();
        try (InputStream responseStream = httpResponse.getResponseStream();){
            Object prefix = remoteTypeName.getLocalPart();
            if (((String)prefix).length() < 3) {
                prefix = (String)prefix + "zzz";
            }
            File tmpSchemaFile = File.createTempFile((String)prefix, ".xsd");
            try (FileOutputStream output = new FileOutputStream(tmpSchemaFile);){
                IOUtils.copy((InputStream)responseStream, (OutputStream)output);
                output.flush();
            }
            try {
                URL schemaLocation = tmpSchemaFile.toURI().toURL();
                this.parsed = EmfAppSchemaParser.parse(wfsConfiguration, remoteTypeName, schemaLocation, defaultCrs, strategy.getFieldTypeMappings(), this.getTempFileEntityResolver(resolver, tmpSchemaFile));
            }
            finally {
                tmpSchemaFile.delete();
            }
        }
        finally {
            httpResponse.dispose();
        }
    }

    public FeatureType getFeatureType() {
        return this.parsed;
    }

    private EntityResolver getTempFileEntityResolver(EntityResolver resolver, File tempSchema) {
        if (resolver == null) {
            return null;
        }
        if (resolver instanceof EntityResolver2) {
            return new TempEntityResolver2((EntityResolver2)resolver, tempSchema);
        }
        return new TempEntityResolver(resolver, tempSchema);
    }

    private static class TempEntityResolver2
    extends TempEntityResolver
    implements EntityResolver2 {
        EntityResolver2 delegate;

        public TempEntityResolver2(EntityResolver2 delegate, File tempSchema) {
            super(delegate, tempSchema);
            this.delegate = delegate;
        }

        @Override
        public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
            return this.delegate.getExternalSubset(name, baseURI);
        }

        @Override
        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
            if (this.isTempSchema(systemId)) {
                return null;
            }
            return this.delegate.resolveEntity(name, publicId, baseURI, systemId);
        }
    }

    private static class TempEntityResolver
    implements EntityResolver {
        private final EntityResolver delegate;
        private Set<String> tempSchemaURIs;

        public TempEntityResolver(EntityResolver delegate, File tempSchema) {
            this.delegate = delegate;
            URL tempSchemaURL = URLs.fileToUrl((File)tempSchema);
            this.tempSchemaURIs = new HashSet<String>(List.of(tempSchemaURL.toExternalForm(), tempSchemaURL.toString()));
            try {
                File canonicalFile = tempSchema.getCanonicalFile();
                URL canonicalSchemaURL = URLs.fileToUrl((File)canonicalFile);
                this.tempSchemaURIs.add(canonicalSchemaURL.toExternalForm());
                this.tempSchemaURIs.add(canonicalSchemaURL.toString());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get canonical file for " + tempSchema, e);
            }
            if (!TempEntityResolver.isFileSystemCaseSensitive(tempSchema)) {
                TreeSet<String> insensitive = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                insensitive.addAll(this.tempSchemaURIs);
                this.tempSchemaURIs = insensitive;
            }
        }

        static boolean isFileSystemCaseSensitive(File knownFile) {
            if (!knownFile.exists()) {
                throw new IllegalArgumentException("The specified file does not exist: " + knownFile);
            }
            File alteredCase = new File(knownFile.getParentFile(), TempEntityResolver.toggleCase(knownFile.getName()));
            return !alteredCase.exists();
        }

        static String toggleCase(String name) {
            char[] chars = name.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (Character.isUpperCase(c)) {
                    chars[i] = Character.toLowerCase(c);
                    continue;
                }
                if (!Character.isLowerCase(c)) continue;
                chars[i] = Character.toUpperCase(c);
            }
            return new String(chars);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (this.isTempSchema(systemId)) {
                return null;
            }
            return this.delegate.resolveEntity(publicId, systemId);
        }

        protected boolean isTempSchema(String systemId) {
            return this.tempSchemaURIs.contains(systemId);
        }
    }
}

