/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.impl;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.util.InternationalString;
import org.geotools.data.DataUtilities;
import org.geotools.data.wfs.impl.WFSContentDataAccess;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.ows.ServiceException;
import org.geotools.util.KVP;
import org.geotools.util.PreventLocalEntityResolver;
import org.geotools.util.SimpleInternationalString;
import org.xml.sax.EntityResolver;

public class WFSDataAccessFactory
implements DataAccessFactory {
    public static final String AXIS_ORDER_EAST_NORTH = "East / North";
    public static final String AXIS_ORDER_NORTH_EAST = "North / East";
    public static final String AXIS_ORDER_COMPLIANT = "Compliant";
    private static final WFSFactoryParam<?>[] parametersInfo = new WFSFactoryParam[24];
    private static final int GMLComplianceLevel = 2;
    public static final WFSFactoryParam<URL> URL;
    public static final WFSFactoryParam<Boolean> PROTOCOL;
    public static final WFSFactoryParam<String> USERNAME;
    public static final WFSFactoryParam<String> PASSWORD;
    public static final WFSFactoryParam<String> ENCODING;
    public static final WFSFactoryParam<Integer> TIMEOUT;
    public static final WFSFactoryParam<Integer> BUFFER_SIZE;
    public static final WFSFactoryParam<Boolean> TRY_GZIP;
    public static final WFSFactoryParam<Boolean> LENIENT;
    public static final WFSFactoryParam<Integer> MAXFEATURES;
    public static final WFSFactoryParam<Integer> FILTER_COMPLIANCE;
    public static final WFSFactoryParam<String> WFS_STRATEGY;
    public static final WFSFactoryParam<String> NAMESPACE;
    public static final WFSFactoryParam<Boolean> USEDEFAULTSRS;
    public static final WFSFactoryParam<String> AXIS_ORDER;
    public static final WFSFactoryParam<String> AXIS_ORDER_FILTER;
    public static final WFSFactoryParam<String> OUTPUTFORMAT;
    public static final WFSFactoryParam<Integer> GML_COMPLIANCE_LEVEL;
    public static final WFSFactoryParam<Boolean> GML_COMPATIBLE_TYPENAMES;
    public static final WFSFactoryParam<EntityResolver> ENTITY_RESOLVER;
    public static final WFSFactoryParam<Boolean> USE_HTTP_CONNECTION_POOLING;
    public static final WFSFactoryParam<Integer> MAX_CONNECTION_POOL_SIZE;
    public static final WFSFactoryParam<String> SCHEMA_CACHE_LOCATION;
    public static final WFSFactoryParam<Map> ADDITIONAL_HEADERS;

    public boolean canProcess(Map<String, ?> params) {
        return this.canProcess(params, 2);
    }

    protected boolean canProcess(Map<String, ?> params, int maximumGmlComplianceLevel) {
        boolean canProcess = DataUtilities.canProcess(params, (DataAccessFactory.Param[])this.getParametersInfo());
        if (!canProcess) {
            return false;
        }
        try {
            URL url = URL.lookUp(params);
            if (url == null) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        if (params.containsKey(WFSDataAccessFactory.USERNAME.key) ? !params.containsKey(WFSDataAccessFactory.PASSWORD.key) : params.containsKey(WFSDataAccessFactory.PASSWORD.key)) {
            return false;
        }
        try {
            Integer complianceLevel = GML_COMPLIANCE_LEVEL.lookUp(params);
            if (complianceLevel != null && complianceLevel > maximumGmlComplianceLevel) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public DataAccess<? extends FeatureType, ? extends Feature> createDataStore(Map<String, ?> params) throws IOException {
        WFSContentDataAccess dataAccess = new WFSContentDataAccess(this.getWFSClient(params));
        if (params.containsKey(WFSDataAccessFactory.SCHEMA_CACHE_LOCATION.key)) {
            String cacheLocation = (String)params.get(WFSDataAccessFactory.SCHEMA_CACHE_LOCATION.key);
            dataAccess.setCacheLocation(new File(cacheLocation));
        }
        return dataAccess;
    }

    public String getDescription() {
        return "Provides access to the Complex Features published a Web Feature Service (experimental), and the ability to perform transactions on the server (when supported / allowed).";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        int length = parametersInfo.length;
        DataAccessFactory.Param[] params = new DataAccessFactory.Param[length];
        System.arraycopy(parametersInfo, 0, params, 0, length);
        return params;
    }

    protected WFSClient getWFSClient(Map<String, ?> params) throws IOException {
        WFSClient wfsClient;
        WFSConfig config = WFSConfig.fromParams(params);
        String user = config.getUser();
        String password = config.getPassword();
        if (user == null && password != null || config.getPassword() == null && config.getUser() != null) {
            throw new IOException("Cannot define only one of USERNAME or PASSWORD, must define both or neither");
        }
        HTTPClient http = HTTPClientFinder.createClient();
        http.setUser(config.getUser());
        http.setPassword(config.getPassword());
        int timeoutMillis = config.getTimeoutMillis();
        http.setConnectTimeout(timeoutMillis / 1000);
        http.setReadTimeout(timeoutMillis / 1000);
        URL capabilitiesURL = URL.lookUp(params);
        try {
            wfsClient = new WFSClient(capabilitiesURL, http, config);
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
        return wfsClient;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    public String getDisplayName() {
        return "Web Complex Feature Server (NG)";
    }

    public boolean isAvailable() {
        return true;
    }

    static {
        String key = "WFSDataStoreFactory:GET_CAPABILITIES_URL";
        String title = "WFS GetCapabilities URL";
        String description = "Represents a URL to the getCapabilities document or a server instance.";
        URL = new WFSFactoryParam<URL>(key, URL.class, title, description);
        WFSDataAccessFactory.parametersInfo[0] = URL;
        key = "WFSDataStoreFactory:PROTOCOL";
        title = "Protocol";
        description = "Sets a preference for the HTTP protocol to use when requesting WFS functionality. Set this value to Boolean.TRUE for POST, Boolean.FALSE for GET or NULL for AUTO";
        PROTOCOL = new WFSFactoryParam<Object>(key, Boolean.class, title, description, null);
        WFSDataAccessFactory.parametersInfo[1] = PROTOCOL;
        key = "WFSDataStoreFactory:USERNAME";
        title = "Username";
        description = "This allows the user to specify a username. This param should not be used without the PASSWORD param.";
        USERNAME = new WFSFactoryParam<String>(key, String.class, title, description);
        WFSDataAccessFactory.parametersInfo[2] = USERNAME;
        key = "WFSDataStoreFactory:PASSWORD";
        title = "Password";
        description = "This allows the user to specify a username. This param should not be used without the USERNAME param.";
        PASSWORD = new WFSFactoryParam<Object>(key, String.class, title, description, null, "isPassword", true);
        WFSDataAccessFactory.parametersInfo[3] = PASSWORD;
        key = "WFSDataStoreFactory:ENCODING";
        title = "Encoding";
        description = "This allows the user to specify the character encoding of the XML-Requests sent to the Server. Defaults to UTF-8";
        String defaultValue = "UTF-8";
        ArrayList<String> options = new ArrayList<String>(Charset.availableCharsets().keySet());
        Collections.sort(options);
        ENCODING = new WFSFactoryParam<String>(key, String.class, title, description, defaultValue, "options", options);
        WFSDataAccessFactory.parametersInfo[4] = ENCODING;
        key = "WFSDataStoreFactory:TIMEOUT";
        title = "Time-out";
        description = "This allows the user to specify a timeout in milliseconds. This param has a default value of 3000ms.";
        TIMEOUT = new WFSFactoryParam<Integer>(key, Integer.class, title, description, 3000);
        WFSDataAccessFactory.parametersInfo[5] = TIMEOUT;
        key = "WFSDataStoreFactory:BUFFER_SIZE";
        title = "Buffer Size";
        description = "This allows the user to specify a buffer size in features. This param has a default value of 10 features.";
        BUFFER_SIZE = new WFSFactoryParam<Integer>(key, Integer.class, title, description, 10);
        WFSDataAccessFactory.parametersInfo[6] = BUFFER_SIZE;
        key = "WFSDataStoreFactory:TRY_GZIP";
        title = "Try GZIP";
        description = "Indicates that datastore should use gzip to transfer data if the server supports it. Default is true";
        TRY_GZIP = new WFSFactoryParam<Boolean>(key, Boolean.class, title, description, Boolean.TRUE);
        WFSDataAccessFactory.parametersInfo[7] = TRY_GZIP;
        key = "WFSDataStoreFactory:LENIENT";
        title = "Lenient";
        description = "Indicates that datastore should do its best to create features from the provided data even if it does not accurately match the schema.  Errors will be logged but the parsing will continue if this is true.  Default is false";
        LENIENT = new WFSFactoryParam<Boolean>(key, Boolean.class, title, description, false);
        WFSDataAccessFactory.parametersInfo[8] = LENIENT;
        key = "WFSDataStoreFactory:MAXFEATURES";
        title = "Maximum features";
        description = "Positive integer used as a hard limit for the amount of Features to retrieve for each FeatureType. A value of zero or not providing this parameter means no limit.";
        MAXFEATURES = new WFSFactoryParam<Integer>(key, Integer.class, title, description, 0);
        WFSDataAccessFactory.parametersInfo[9] = MAXFEATURES;
        key = "WFSDataStoreFactory:FILTER_COMPLIANCE";
        title = "Filter compliance";
        description = "Level of compliance to WFS specification (0-low,1-medium,2-high)";
        List<Object> options2 = Arrays.asList(0, 1, 2);
        FILTER_COMPLIANCE = new WFSFactoryParam<Object>(key, Integer.class, title, description, null, "options", options2);
        WFSDataAccessFactory.parametersInfo[10] = FILTER_COMPLIANCE;
        key = "WFSDataStoreFactory:WFS_STRATEGY";
        title = "WFS Strategy";
        description = "Override wfs stragegy with either cubwerx, ionic, mapserver, geoserver, strict, nonstrict or arcgis strategy.";
        options2 = Arrays.asList("auto", "strict", "nonstrict", "mapserver", "geoserver", "cubewerx", "ionic", "arcgis");
        WFS_STRATEGY = new WFSFactoryParam<String>(key, String.class, title, description, "auto", "options", options2);
        WFSDataAccessFactory.parametersInfo[11] = WFS_STRATEGY;
        key = "namespace";
        title = "Namespace";
        description = "Override the original WFS type name namespaces";
        NAMESPACE = new WFSFactoryParam<Object>(key, String.class, title, description, null, "advanced");
        WFSDataAccessFactory.parametersInfo[12] = NAMESPACE;
        key = "usedefaultsrs";
        title = "Use Default SRS";
        description = "Use always the declared DefaultSRS for requests and reproject locally if necessary";
        USEDEFAULTSRS = new WFSFactoryParam<Boolean>(key, Boolean.class, title, description, Boolean.valueOf(false), "advanced");
        WFSDataAccessFactory.parametersInfo[13] = USEDEFAULTSRS;
        key = "WFSDataStoreFactory:AXIS_ORDER";
        title = "Axis Order";
        description = "Indicates axis order used by the remote WFS server in result coordinates. It applies only to WFS 1.x.0 servers. Default is Compliant";
        options2 = Arrays.asList(AXIS_ORDER_COMPLIANT, AXIS_ORDER_EAST_NORTH, AXIS_ORDER_NORTH_EAST);
        AXIS_ORDER = new WFSFactoryParam<String>(key, String.class, title, description, AXIS_ORDER_COMPLIANT, "options", options2, "level", "advanced");
        WFSDataAccessFactory.parametersInfo[14] = AXIS_ORDER;
        key = "WFSDataStoreFactory:AXIS_ORDER_FILTER";
        title = "Axis Order Filter";
        description = "Indicates axis order used by the remote WFS server for filters. It applies only to WFS 1.x.0 servers. Default is the same as AXIS_ORDER";
        options2 = Arrays.asList(AXIS_ORDER_COMPLIANT, AXIS_ORDER_EAST_NORTH, AXIS_ORDER_NORTH_EAST);
        AXIS_ORDER_FILTER = new WFSFactoryParam<Object>(key, String.class, title, description, null, "options", options2, "level", "advanced");
        WFSDataAccessFactory.parametersInfo[15] = AXIS_ORDER_FILTER;
        key = "WFSDataStoreFactory:OUTPUTFORMAT";
        title = "Outputformat";
        description = "This allows the user to specify an outputFormat, different from the default one.";
        OUTPUTFORMAT = new WFSFactoryParam<Object>(key, String.class, title, description, null, "advanced");
        WFSDataAccessFactory.parametersInfo[16] = OUTPUTFORMAT;
        String name = "WFSDataStoreFactory:GML_COMPLIANCE_LEVEL";
        title = "GmlComplianceLevel";
        description = "Optional OGC GML compliance level required.";
        GML_COMPLIANCE_LEVEL = new WFSFactoryParam<Integer>(name, Integer.class, title, description, 0);
        WFSDataAccessFactory.parametersInfo[17] = GML_COMPLIANCE_LEVEL;
        name = "WFSDataStoreFactory:GML_COMPATIBLE_TYPENAMES";
        title = "GmlCompatibleTypeNames";
        description = "Use Gml Compatible TypeNames (replace : by _).";
        GML_COMPATIBLE_TYPENAMES = new WFSFactoryParam<Boolean>(name, Boolean.class, title, description, false);
        WFSDataAccessFactory.parametersInfo[18] = GML_COMPATIBLE_TYPENAMES;
        name = "WFSDataStoreFactory:ENTITY_RESOLVER";
        title = "EntityResolver";
        description = "Sets the entity resolver used to expand XML entities";
        ENTITY_RESOLVER = new WFSFactoryParam<PreventLocalEntityResolver>(name, EntityResolver.class, title, description, PreventLocalEntityResolver.INSTANCE, "level", "program");
        WFSDataAccessFactory.parametersInfo[19] = ENTITY_RESOLVER;
        name = "WFSDataStoreFactory:USE_HTTP_CONNECTION_POOLING";
        title = "Use HTTP Connection Pooling";
        description = "Sets the usage of connection pooling for http(s) requests";
        USE_HTTP_CONNECTION_POOLING = new WFSFactoryParam<Boolean>(name, Boolean.class, title, description, true);
        WFSDataAccessFactory.parametersInfo[20] = USE_HTTP_CONNECTION_POOLING;
        name = "WFSDataStoreFactory:MAX_CONNECTION_POOL_SIZE";
        title = "Set the default connection pool size";
        description = "Sets the default connection pool size for http(s) requests";
        MAX_CONNECTION_POOL_SIZE = new WFSFactoryParam<Integer>(name, Integer.class, title, description, 6);
        WFSDataAccessFactory.parametersInfo[21] = MAX_CONNECTION_POOL_SIZE;
        name = "WFSDataStoreFactory:SCHEMA_CACHE_LOCATION";
        title = "Set location for storing cache of schema's.";
        description = "During encoding of xml responses, the corresponding xsd schema will be downloaded and curated. By setting this parameter it's possible to avoid repeated downloads.";
        SCHEMA_CACHE_LOCATION = new WFSFactoryParam<Object>(name, String.class, title, description, null, "program");
        WFSDataAccessFactory.parametersInfo[22] = SCHEMA_CACHE_LOCATION;
        name = "WFSDataStoreFactory:ADDITIONAL_HEADERS";
        title = "Set additional HTTP request headers.";
        description = "The given HTTP headers will be set on HTTP requests in addition to the regular GeoTools managed headers (like Accept-Enconding, Content-type, User-Agent, Authorization). Provided values must not conflict with GeoTools managed headers. Parameters must use String keys and values.";
        ADDITIONAL_HEADERS = new WFSFactoryParam<Object>(name, Map.class, title, description, null, "program");
        WFSDataAccessFactory.parametersInfo[23] = ADDITIONAL_HEADERS;
    }

    public static class WFSFactoryParam<T>
    extends DataAccessFactory.Param {
        private T defaultValue;

        public WFSFactoryParam(String key, Class<T> type, String title, String description) {
            this(key, type, title, description, null);
        }

        public WFSFactoryParam(String key, Class<T> type, String title, String description, T defaultValue) {
            super(key, type, (InternationalString)new SimpleInternationalString(title), (InternationalString)new SimpleInternationalString(description), false, -1, -1, defaultValue, null);
            this.defaultValue = defaultValue;
        }

        public WFSFactoryParam(String key, Class<T> type, String title, String description, T defaultValue, String level) {
            this(key, type, title, description, defaultValue, "level", level);
            this.defaultValue = defaultValue;
        }

        public WFSFactoryParam(String key, Class<T> type, String title, String description, T defaultValue, Object ... metadata) {
            super(key, type, (InternationalString)new SimpleInternationalString(title), (InternationalString)new SimpleInternationalString(description), false, -1, -1, defaultValue, (Map)new KVP(metadata));
            this.defaultValue = defaultValue;
        }

        public T lookUp(Map params) throws IOException {
            Object parameter = super.lookUp(params);
            return (T)(parameter == null ? this.defaultValue : parameter);
        }
    }
}

