/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.util.Collection;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.data.wfs.MutableFeatureId;
import org.geotools.feature.AbstractFeatureFactoryImpl;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.filter.FilterFactoryImpl;

class MutableIdentifierFeatureFactory
extends AbstractFeatureFactoryImpl {
    private static FilterFactory MUTABLE_FIDS_FILTER_FACTORY = new FilterFactoryImpl(){

        public MutableFeatureId featureId(String id) {
            return new MutableFeatureId(id);
        }

        public MutableFeatureId featureId(String fid, String featureVersion) {
            return new MutableFeatureId(fid, featureVersion);
        }
    };

    MutableIdentifierFeatureFactory() {
    }

    public Feature createFeature(Collection value, AttributeDescriptor descriptor, String id) {
        return new FeatureImpl(value, descriptor, MUTABLE_FIDS_FILTER_FACTORY.featureId(id));
    }

    public Feature createFeature(Collection value, FeatureType type, String id) {
        return new FeatureImpl(value, type, MUTABLE_FIDS_FILTER_FACTORY.featureId(id));
    }

    public SimpleFeature createSimpleFeature(Object[] array, SimpleFeatureType type, String id) {
        if (type.isAbstract()) {
            throw new IllegalArgumentException("Cannot create an feature of an abstract FeatureType " + type.getTypeName());
        }
        return new SimpleFeatureImpl(array, type, MUTABLE_FIDS_FILTER_FACTORY.featureId(id), false);
    }
}

