/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.opengis.wfs20.WFSCapabilitiesType;
import org.apache.commons.io.IOUtils;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.DataSourceException;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.wfs.internal.AbstractWFSStrategy;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.Versions;
import org.geotools.data.wfs.internal.WFSGetCapabilities;
import org.geotools.ows.ServiceException;
import org.geotools.util.Version;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class GetCapabilitiesResponse
extends org.geotools.data.ows.GetCapabilitiesResponse {
    private WFSGetCapabilities capabilities;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetCapabilitiesResponse(HTTPResponse response, EntityResolver entityResolver) throws IOException, ServiceException {
        super(response);
        Loggers.MODULE.finer("Parsing GetCapabilities response");
        try {
            Document rawDocument;
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            try (InputStream inputStream = response.getResponseStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)buff);
            }
            byte[] rawResponse = buff.toByteArray();
            if (Loggers.RESPONSES.isLoggable(Level.FINE)) {
                Loggers.RESPONSES.fine("Full GetCapabilities response: " + new String(rawResponse));
            }
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setNamespaceAware(true);
                builderFactory.setValidating(false);
                DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
                if (entityResolver != null) {
                    documentBuilder.setEntityResolver(entityResolver);
                }
                rawDocument = documentBuilder.parse(new ByteArrayInputStream(rawResponse));
            }
            catch (Exception e) {
                throw new IOException("Error parsing capabilities document: " + e.getMessage(), e);
            }
            List<Configuration> tryConfigs = Arrays.asList(AbstractWFSStrategy.WFS_2_0_CONFIGURATION, AbstractWFSStrategy.WFS_1_1_CONFIGURATION, AbstractWFSStrategy.WFS_1_0_CAPABILITIES_CONFIGURATION);
            String versionAtt = rawDocument.getDocumentElement().getAttribute("version");
            Version version = null;
            if (null != versionAtt) {
                version = new Version(versionAtt);
                if (Versions.v1_0_0.equals((Object)version)) {
                    tryConfigs = Collections.singletonList(AbstractWFSStrategy.WFS_1_0_CAPABILITIES_CONFIGURATION);
                } else if (Versions.v1_1_0.equals((Object)version)) {
                    tryConfigs = Collections.singletonList(AbstractWFSStrategy.WFS_1_1_CONFIGURATION);
                } else if (Versions.v2_0_0.equals((Object)version)) {
                    tryConfigs = Collections.singletonList(AbstractWFSStrategy.WFS_2_0_CONFIGURATION);
                }
            }
            EObject parsedCapabilities = null;
            for (Configuration wfsConfig : tryConfigs) {
                try {
                    parsedCapabilities = this.parseCapabilities(rawDocument, wfsConfig);
                    if (parsedCapabilities == null) continue;
                    break;
                }
                catch (Exception e) {
                    Logger.getGlobal().log(Level.INFO, "", e);
                }
            }
            if (null == parsedCapabilities) {
                throw new IllegalStateException("Unable to parse GetCapabilities document");
            }
            this.capabilities = WFSGetCapabilities.create(parsedCapabilities, rawDocument);
        }
        finally {
            response.dispose();
        }
    }

    private EObject parseCapabilities(Document document, Configuration wfsConfig) throws IOException {
        Object parsed;
        DOMParser parser = new DOMParser(wfsConfig, document);
        try {
            parsed = parser.parse();
        }
        catch (Exception e) {
            throw new DataSourceException("Exception parsing WFS capabilities", (Throwable)e);
        }
        if (parsed == null) {
            throw new DataSourceException("WFS capabilities was not parsed");
        }
        if (!(parsed instanceof net.opengis.wfs.WFSCapabilitiesType) && !(parsed instanceof WFSCapabilitiesType)) {
            throw new DataSourceException("Expected WFS Capabilities, got " + parsed);
        }
        EObject object = (EObject)parsed;
        return object;
    }

    public WFSGetCapabilities getCapabilities() {
        return this.capabilities;
    }
}

