/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.GetFeatureResponse;
import org.geotools.data.wfs.internal.GetParser;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.data.wfs.internal.parsers.AbstractWFSResponseFactory;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.FeatureType;

public abstract class AbstractGetFeatureResponseParserFactory
extends AbstractWFSResponseFactory {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean canProcess(WFSRequest request, String contentType) {
        if (!WFSOperationType.GET_FEATURE.equals((Object)request.getOperation())) {
            return false;
        }
        if (!this.getSupportedVersions().contains(request.getStrategy().getVersion())) {
            return false;
        }
        boolean matches = this.getSupportedOutputFormats().contains(contentType);
        if (!matches) {
            for (String supported : this.getSupportedOutputFormats()) {
                if (!supported.startsWith(contentType) && !contentType.startsWith(supported)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    @Override
    protected WFSResponse createResponseImpl(WFSRequest request, HTTPResponse response, InputStream in) throws IOException {
        GetParser<SimpleFeature> parser = this.parser((GetFeatureRequest)request, in);
        try {
            return new GetFeatureResponse(request, response, parser);
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected boolean isValidResponseHead(String head) {
        return head.indexOf("FeatureCollection") > 0;
    }

    @Override
    public boolean canProcess(WFSOperationType operation) {
        return WFSOperationType.GET_FEATURE.equals((Object)operation);
    }

    protected FeatureType getRequestedType(GetFeatureRequest request) {
        FeatureType queryType = request.getQueryType();
        if (queryType == null) {
            queryType = request.getFullType();
        }
        return queryType;
    }

    protected abstract GetParser<SimpleFeature> parser(GetFeatureRequest var1, InputStream var2) throws IOException;

    protected abstract List<String> getSupportedVersions();
}

