/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.opengis.wfs20.DescribeStoredQueriesResponseType;
import net.opengis.wfs20.StoredQueryDescriptionType;
import org.apache.commons.io.IOUtils;
import org.geotools.data.DataSourceException;
import org.geotools.data.wfs.internal.AbstractWFSStrategy;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.DOMParser;
import org.w3c.dom.Document;

public class DescribeStoredQueriesResponse
extends WFSResponse {
    private DescribeStoredQueriesResponseType describeStoredQueriesResponse;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescribeStoredQueriesResponse(WFSRequest originatingRequest, HTTPResponse response) throws IOException, ServiceException {
        super(originatingRequest, response);
        Loggers.MODULE.finer("Parsing DescribeStoredQueries response");
        try {
            Document rawDocument;
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            try (InputStream inputStream = response.getResponseStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)buff);
            }
            byte[] rawResponse = buff.toByteArray();
            if (Loggers.RESPONSES.isLoggable(Level.FINE)) {
                Loggers.RESPONSES.fine("Full ListStoredQueries response: " + new String(rawResponse));
            }
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setNamespaceAware(true);
                builderFactory.setValidating(false);
                DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
                rawDocument = documentBuilder.parse(new ByteArrayInputStream(rawResponse));
            }
            catch (Exception e) {
                throw new IOException("Error parsing capabilities document: " + e.getMessage(), e);
            }
            this.describeStoredQueriesResponse = this.parseStoredQueries(rawDocument, AbstractWFSStrategy.WFS_2_0_CONFIGURATION);
            if (null == this.describeStoredQueriesResponse) {
                throw new IllegalStateException("Unable to parse DescribeStoredQueriesResponse document");
            }
        }
        finally {
            response.dispose();
        }
    }

    private DescribeStoredQueriesResponseType parseStoredQueries(Document document, Configuration wfsConfig) throws DataSourceException {
        Object parsed;
        DOMParser parser = new DOMParser(wfsConfig, document);
        try {
            parsed = parser.parse();
        }
        catch (Exception e) {
            throw new DataSourceException("Exception parsing DescribeStoredQueriesResponse", (Throwable)e);
        }
        if (!(parsed instanceof DescribeStoredQueriesResponseType)) {
            throw new DataSourceException("DescribedStoredQueries response is not a DescribeStoredQueriesResponseType but a " + String.valueOf(parsed.getClass()));
        }
        return (DescribeStoredQueriesResponseType)parsed;
    }

    public List<StoredQueryDescriptionType> getStoredQueryDescriptions() {
        return this.describeStoredQueriesResponse.getStoredQueryDescription();
    }
}

