/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vsi;

import it.geosolutions.imageio.plugins.vrt.VRTImageReaderSpi;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.coverageio.gdal.BaseGDALGridFormat;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.geotools.vsi.VSIReader;

public final class VSIFormat
extends BaseGDALGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(VSIFormat.class);

    public VSIFormat() {
        super((ImageReaderSpi)new VRTImageReaderSpi());
        LOGGER.fine("Creating a new VSIFormat.");
        this.setInfo();
    }

    protected void setInfo() {
        this.setInfo(new BaseGDALGridFormat.InfoWrapper("VSI Virtual File System", "VSI"));
    }

    public VSIReader getReader(Object source, Hints hints) {
        try {
            return new VSIReader(source, hints);
        }
        catch (IOException | MismatchedDimensionException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
    }
}

