/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.vpf.VPFFeatureSource;
import org.geotools.data.vpf.VPFLogger;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;

public class VPFFileStore
extends ContentDataStore {
    private Map<String, SimpleFeatureType> files = new HashMap<String, SimpleFeatureType>();
    private String vpfFilePath;

    public VPFFileStore(String vpfFilePath) throws IOException {
        this.vpfFilePath = vpfFilePath;
        this.getTypeSchema(vpfFilePath);
    }

    public String getVpfFilePath() {
        return this.vpfFilePath;
    }

    public List<Name> getNames() {
        ArrayList<Name> result = new ArrayList<Name>();
        for (SimpleFeatureType currentFile : this.files.values()) {
            result.add((Name)new NameImpl(currentFile.getTypeName()));
        }
        return result;
    }

    public SimpleFeatureType getFeatureType(ContentEntry entry) throws IOException {
        String typeName = entry.getTypeName();
        return this.getTypeSchema(typeName);
    }

    protected List<Name> createTypeNames() throws IOException {
        return this.getNames();
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        String typeName = entry.getTypeName();
        if (typeName == null) {
            return null;
        }
        return this.getFeatureSource(typeName);
    }

    public ContentFeatureSource getFeatureSource(String typeName) throws IOException {
        VPFFeatureSource featureSource = VPFFeatureSource.getFeatureSource(typeName);
        if (featureSource == null) {
            featureSource = VPFFeatureSource.getFeatureSource(typeName.toUpperCase());
        }
        if (featureSource == null) {
            if (VPFLogger.isLoggable(Level.FINEST)) {
                VPFLogger.log("VPFFileStore.getFeatureSource returned null: " + typeName);
            }
            Query query = new Query(typeName);
            ContentEntry entry = this.entry((Name)new NameImpl(typeName));
            featureSource = new VPFFileFeatureSource(entry, query);
        }
        return featureSource;
    }

    public SimpleFeatureType getTypeSchema(String pathName) throws IOException {
        SimpleFeatureType result = null;
        if (this.files.containsKey(pathName)) {
            result = this.files.get(pathName);
        } else {
            try {
                VPFFile file = this.findFile(pathName);
                result = file.getFeatureType();
            }
            catch (SchemaException exc) {
                throw new IOException("Schema error in path: " + pathName + "\n" + exc.getMessage());
            }
            this.files.put(pathName, result);
        }
        return result;
    }

    public VPFFile getFile(String pathName) throws IOException {
        SimpleFeatureType featureType = this.getTypeSchema(pathName);
        if (featureType == null) {
            return null;
        }
        VPFFile file = (VPFFile)featureType.getUserData().get(VPFFile.class);
        return file;
    }

    public void reset() {
        Iterator<SimpleFeatureType> iter = this.files.values().iterator();
        VPFFile file = null;
        while (iter.hasNext()) {
            try {
                SimpleFeatureType schema = iter.next();
                file = (VPFFile)schema.getUserData().get(VPFFile.class);
                file.close();
            }
            catch (Exception e) {
                this.LOGGER.log(Level.SEVERE, "", e);
            }
        }
        this.files.clear();
    }

    private VPFFile findFile(String pathName) throws IOException, SchemaException {
        if (new File(pathName).exists()) {
            return new VPFFile(pathName);
        }
        ArrayList<String> matches = new ArrayList<String>();
        matches.add("");
        StringTokenizer st = new StringTokenizer(pathName, File.separator);
        while (st.hasMoreTokens() && !matches.isEmpty()) {
            String curr = st.nextToken();
            String currUpper = curr.toUpperCase();
            String currLower = curr.toLowerCase();
            boolean useUpper = !curr.equals(currUpper);
            boolean useLower = !curr.equals(currLower);
            ArrayList<CallSite> newMatches = new ArrayList<CallSite>();
            for (String match : matches) {
                String tmp = match + File.separator + curr;
                if (new File(tmp).exists()) {
                    newMatches.add((CallSite)((Object)tmp));
                    continue;
                }
                if (useUpper && new File(tmp = match + File.separator + currUpper).exists()) {
                    newMatches.add((CallSite)((Object)tmp));
                }
                if (!useLower || !new File(tmp = match + File.separator + currLower).exists()) continue;
                newMatches.add((CallSite)((Object)tmp));
            }
            matches = newMatches;
        }
        if (matches.isEmpty()) {
            throw new FileNotFoundException("Could not find file: " + pathName);
        }
        return new VPFFile((String)matches.get(0));
    }
}

