/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.file;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.data.vpf.VPFColumn;
import org.geotools.data.vpf.VPFLogger;
import org.geotools.data.vpf.exc.VPFHeaderFormatException;
import org.geotools.data.vpf.io.TripletId;
import org.geotools.data.vpf.io.VPFInputStream;
import org.geotools.data.vpf.io.VariableIndexInputStream;
import org.geotools.data.vpf.io.VariableIndexRow;
import org.geotools.data.vpf.util.DataUtils;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AnnotationFeatureType;
import org.geotools.text.Text;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class VPFFile {
    private static String ACCESS_MODE = "r";
    static final Logger LOGGER = Logging.getLogger(VPFFile.class);
    private char byteOrder = (char)76;
    private final List<VPFColumn> columns = new ArrayList<VPFColumn>();
    private String description = null;
    private final SimpleFeatureType featureType;
    private int headerLength = 0;
    private RandomAccessFile inputStream = null;
    private String narrativeTable = null;
    private final String pathName;
    private VPFInputStream variableIndex = null;

    public VPFFile(String cPathName) throws IOException, SchemaException {
        this.pathName = cPathName;
        this.inputStream = new RandomAccessFile(cPathName, ACCESS_MODE);
        this.readHeader();
        VPFColumn column2 = null;
        String geometryName = null;
        for (VPFColumn column2 : this.columns) {
            if (!column2.isGeometry()) continue;
            geometryName = column2.getName();
            break;
        }
        SimpleFeatureType superType = null;
        if (this.pathName.endsWith("TXT")) {
            superType = AnnotationFeatureType.ANNOTATION;
        }
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(cPathName);
        b.setDescription(Text.text((String)this.description));
        b.setNamespaceURI("VPF");
        b.setSuperType(superType);
        if (this.columns != null) {
            for (VPFColumn ad : this.columns) {
                b.add(ad.getDescriptor());
            }
        }
        b.setDefaultGeometry(geometryName);
        this.featureType = b.buildFeatureType();
        this.featureType.getUserData().put(VPFFile.class, this);
    }

    private int getAdjustedHeaderLength() {
        return this.headerLength + 4;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public int getAttributeCount() {
        return this.featureType.getAttributeCount();
    }

    public char getByteOrder() {
        return this.byteOrder;
    }

    public String getDirectoryName() {
        String result = "";
        int index = this.pathName.lastIndexOf(File.separator);
        if (index >= 0) {
            result = this.pathName.substring(0, index);
        }
        return result;
    }

    public String getFileName() {
        String result = this.pathName.substring(this.pathName.lastIndexOf(File.separator) + 1);
        return result;
    }

    public String getNarrativeTable() {
        return this.narrativeTable;
    }

    public String getPathName() {
        return this.pathName;
    }

    protected synchronized int getRecordSize() {
        int size = 0;
        for (VPFColumn column : this.columns) {
            int length = FeatureTypes.getFieldLength((PropertyDescriptor)column.getDescriptor());
            if (length <= -1) continue;
            size += length;
        }
        return size;
    }

    public SimpleFeature getRowFromId(String idName, int id) {
        SimpleFeature result = null;
        Integer theId = id;
        try {
            SimpleFeature row;
            this.reset();
            while (this.hasNext() && (row = this.readFeature()) != null) {
                Object rowId = row.getAttribute(idName);
                if (!Objects.equals(theId, rowId)) continue;
                result = row;
                break;
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public SimpleFeature getRowFromId0(String idName, int id) {
        SimpleFeature result = null;
        try {
            String firstColumnName = this.columns.get(0).getName();
            if (idName.equals(firstColumnName)) {
                this.setPosition(id);
                result = this.readFeature();
                Number value = (Number)result.getAttribute(idName);
                if (value == null || value.intValue() != id) {
                    result = null;
                }
            }
            if (result == null) {
                AbstractList<SimpleFeature> allRows = this.readAllRows();
                Iterator<SimpleFeature> joinedIter = allRows.iterator();
                result = this.getRowFromIterator(joinedIter, idName, id);
            }
        }
        catch (IOException exc) {
            LOGGER.log(Level.SEVERE, "", exc);
        }
        return result;
    }

    private synchronized SimpleFeature getRowFromIterator(Iterator<SimpleFeature> iter, String idName, int id) {
        SimpleFeature result = null;
        int value = -1;
        while (iter.hasNext()) {
            SimpleFeature currentFeature = iter.next();
            try {
                value = Integer.parseInt(currentFeature.getAttribute(idName).toString());
                if (id != value) continue;
                result = currentFeature;
                break;
            }
            catch (NumberFormatException exc) {
                LOGGER.log(Level.SEVERE, "", exc);
            }
        }
        return result;
    }

    public String getTypeName() {
        return this.featureType.getTypeName();
    }

    public synchronized boolean hasNext() {
        boolean result = false;
        try {
            int recordSize = this.getRecordSize();
            result = recordSize > 0 ? this.inputStream.length() >= this.inputStream.getFilePointer() + (long)recordSize : this.inputStream.length() >= this.inputStream.getFilePointer() + 1L;
        }
        catch (IOException exc) {
            LOGGER.log(Level.SEVERE, "", exc);
        }
        return result;
    }

    public synchronized boolean isAbstract() {
        return this.featureType.isAbstract();
    }

    public synchronized AbstractList<SimpleFeature> readAllRows() throws IOException {
        LinkedList<SimpleFeature> list = new LinkedList<SimpleFeature>();
        try {
            this.setPosition(1L);
        }
        catch (IOException exc) {
            return list;
        }
        try {
            SimpleFeature row = this.readFeature();
            while (row != null) {
                ((AbstractList)list).add(row);
                if (this.hasNext()) {
                    row = this.readFeature();
                    continue;
                }
                row = null;
            }
        }
        catch (IllegalAttributeException exc1) {
            throw new IOException(exc1.getMessage());
        }
        return list;
    }

    protected synchronized char readChar() throws IOException {
        return (char)this.inputStream.read();
    }

    private synchronized VPFColumn readColumn() throws VPFHeaderFormatException, IOException, NumberFormatException {
        char ctrl = this.readChar();
        if (ctrl == ';') {
            return null;
        }
        String name = ctrl + this.readString("=");
        char type = this.readChar();
        ctrl = this.readChar();
        if (ctrl != ',') {
            throw new VPFHeaderFormatException("Header format does not fit VPF file definition.");
        }
        String elemStr = this.readString(String.valueOf(',')).trim();
        if (elemStr.equals("*")) {
            elemStr = "-1";
        }
        int elements = Integer.parseInt(elemStr);
        char key = this.readChar();
        ctrl = this.readChar();
        if (ctrl != ',') {
            throw new VPFHeaderFormatException("Header format does not fit VPF file definition.");
        }
        String colDesc = this.readString(String.valueOf(',') + ":");
        String descTableName = this.readString(String.valueOf(',') + ":");
        String indexFile = this.readString(String.valueOf(',') + ":");
        String narrTable = this.readString(String.valueOf(',') + ":");
        return new VPFColumn(name, type, elements, key, colDesc, descTableName, indexFile, narrTable);
    }

    protected synchronized Object readGeometry(int instancesCount, int dimensionality, boolean readDoubles) throws IOException {
        Object result = null;
        Coordinate coordinate = null;
        CoordinateList coordinates = new CoordinateList();
        GeometryFactory factory = new GeometryFactory();
        for (int inx = 0; inx < instancesCount; ++inx) {
            switch (dimensionality) {
                case 2: {
                    coordinate = new Coordinate(readDoubles ? this.readDouble() : (double)this.readFloat(), readDoubles ? this.readDouble() : (double)this.readFloat());
                    break;
                }
                case 3: {
                    coordinate = new Coordinate(readDoubles ? this.readDouble() : (double)this.readFloat(), readDoubles ? this.readDouble() : (double)this.readFloat(), readDoubles ? this.readDouble() : (double)this.readFloat());
                    break;
                }
            }
            coordinates.add(coordinate);
        }
        if (this.pathName.endsWith("TXT") && coordinates.size() > 2) {
            Object o = coordinates.remove(1);
            coordinates.add((Object)((Coordinate)o));
        }
        result = instancesCount == 1 ? factory.createPoint(coordinate) : factory.createLineString((CoordinateSequence)new CoordinateArraySequence(coordinates.toCoordinateArray()));
        return result;
    }

    protected synchronized double readDouble() throws IOException {
        return DataUtils.decodeDouble(this.readNumber(8));
    }

    public synchronized SimpleFeature readFeature() throws IOException, IllegalAttributeException {
        SimpleFeature result = null;
        boolean textPrimitive = this.pathName.endsWith("TXT");
        int size = this.columns.size();
        if (textPrimitive) {
            ++size;
        }
        Object[] values = new Object[size];
        boolean debug = VPFLogger.isLoggable(Level.FINEST);
        try {
            for (int inx = 0; inx < this.columns.size(); ++inx) {
                VPFColumn column = this.columns.get(inx);
                AttributeDescriptor descriptor = column.getDescriptor();
                values[inx] = descriptor.getType().getRestrictions().isEmpty() || descriptor.getType().getRestrictions().contains(Filter.INCLUDE) ? this.readVariableSizeData(column.getTypeChar()) : this.readFixedSizeData(column.getTypeChar(), column.getElementsNumber());
            }
            if (textPrimitive) {
                values[size - 1] = "nam";
            }
            result = SimpleFeatureBuilder.build((SimpleFeatureType)this.featureType, (Object[])values, null);
        }
        catch (EOFException exp) {
            LOGGER.log(Level.SEVERE, "", exp);
            debug = true;
            result = null;
        }
        if (debug) {
            Integer recordSize = this.getRecordSize();
            Long streamLength = this.inputStream.length();
            Long filePointer = this.inputStream.getFilePointer();
            VPFLogger.log("************** EOFException");
            VPFLogger.log("recordSize: " + recordSize);
            VPFLogger.log("streamLength: " + streamLength);
            VPFLogger.log("filePointer: " + filePointer);
        }
        return result;
    }

    protected synchronized Object readFixedSizeData(char dataType, int instancesCount) throws IOException {
        Object result = null;
        switch (dataType) {
            case 'L': 
            case 'M': 
            case 'N': 
            case 'T': {
                byte[] dataBytes = new byte[instancesCount * DataUtils.getDataTypeSize(dataType)];
                this.inputStream.readFully(dataBytes);
                result = DataUtils.decodeData(dataBytes, dataType);
                break;
            }
            case 'F': {
                result = Float.valueOf(this.readFloat());
                break;
            }
            case 'R': {
                result = this.readDouble();
                break;
            }
            case 'S': {
                result = this.readShort();
                break;
            }
            case 'I': {
                result = this.readInteger();
                break;
            }
            case 'X': {
                result = "NULL";
                break;
            }
            case 'K': {
                result = this.readTripletId();
                break;
            }
            case 'C': {
                result = this.readGeometry(instancesCount, 2, false);
                break;
            }
            case 'B': {
                result = this.readGeometry(instancesCount, 2, true);
                break;
            }
            case 'Z': {
                result = this.readGeometry(instancesCount, 3, false);
                break;
            }
            case 'Y': {
                result = this.readGeometry(instancesCount, 3, true);
                break;
            }
        }
        return result;
    }

    protected synchronized float readFloat() throws IOException {
        return DataUtils.decodeFloat(this.readNumber(4));
    }

    protected synchronized void readHeader() throws VPFHeaderFormatException, IOException {
        byte[] fourBytes = new byte[4];
        this.inputStream.readFully(fourBytes);
        char ctrl = this.byteOrder = this.readChar();
        if (this.byteOrder == ';') {
            this.byteOrder = (char)76;
        } else {
            ctrl = this.readChar();
        }
        if (this.byteOrder == 'L') {
            fourBytes = DataUtils.toBigEndian(fourBytes);
        }
        this.headerLength = DataUtils.decodeInt(fourBytes);
        if (ctrl != ';') {
            throw new VPFHeaderFormatException("Header format does not fit VPF file definition.");
        }
        this.description = this.readString(String.valueOf(';'));
        this.narrativeTable = this.readString(String.valueOf(';'));
        VPFColumn column = this.readColumn();
        while (column != null) {
            this.columns.add(column);
            ctrl = this.readChar();
            if (ctrl != ':' && ctrl != ';') {
                throw new VPFHeaderFormatException("Header format does not fit VPF file definition.");
            }
            if (ctrl == ';') {
                column = null;
                continue;
            }
            column = this.readColumn();
        }
        if (this.getRecordSize() < 0) {
            this.variableIndex = new VariableIndexInputStream(this.getVariableIndexFileName(), this.getByteOrder());
        }
    }

    protected synchronized int readInteger() throws IOException {
        return DataUtils.decodeInt(this.readNumber(4));
    }

    protected synchronized byte[] readNumber(int cnt) throws IOException {
        byte[] dataBytes = new byte[cnt];
        boolean exception = false;
        boolean debug = false;
        EOFException e2 = null;
        try {
            this.inputStream.readFully(dataBytes);
            if (this.byteOrder == 'L') {
                dataBytes = DataUtils.toBigEndian(dataBytes);
            }
        }
        catch (EOFException e) {
            exception = true;
            debug = true;
            e2 = e;
        }
        if (debug) {
            Integer recordSize = this.getRecordSize();
            Long streamLength = this.inputStream.length();
            Long filePointer = this.inputStream.getFilePointer();
            Integer icnt = cnt;
            VPFLogger.log("************** EOFException");
            VPFLogger.log("cnt: " + icnt);
            VPFLogger.log("recordSize: " + recordSize);
            VPFLogger.log("streamLength: " + streamLength);
            VPFLogger.log("filePointer: " + filePointer);
        }
        if (exception) {
            throw e2;
        }
        return dataBytes;
    }

    protected synchronized short readShort() throws IOException {
        return DataUtils.decodeShort(this.readNumber(2));
    }

    protected synchronized String readString(String terminators) throws IOException {
        StringBuffer text = new StringBuffer();
        char ctrl = this.readChar();
        if (terminators.indexOf(ctrl) != -1) {
            if (ctrl == ':') {
                this.unread(1L);
            }
            return null;
        }
        while (terminators.indexOf(ctrl) == -1) {
            text.append(ctrl);
            ctrl = this.readChar();
        }
        if (text.toString().equals("-")) {
            return null;
        }
        return text.toString();
    }

    protected synchronized TripletId readTripletId() throws IOException {
        byte tripletDef = (byte)this.inputStream.read();
        int dataSize = TripletId.calculateDataSize(tripletDef);
        byte[] tripletData = new byte[dataSize + 1];
        tripletData[0] = tripletDef;
        if (dataSize > 0) {
            this.inputStream.readFully(tripletData, 1, dataSize);
        }
        return new TripletId(tripletData);
    }

    protected synchronized Object readVariableSizeData(char dataType) throws IOException {
        int instances = this.readInteger();
        try {
            return this.readFixedSizeData(dataType, instances);
        }
        catch (EOFException e) {
            VPFLogger.log("************ readVariableSizeData error");
            VPFLogger.log("instance count: " + instances);
            throw e;
        }
    }

    public synchronized void reset() {
        try {
            this.setPosition(1L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void close() throws IOException {
        this.inputStream.close();
        if (this.variableIndex != null) {
            this.variableIndex.close();
        }
    }

    protected synchronized void setPosition(long pos) throws IOException {
        if (this.getRecordSize() < 0) {
            VariableIndexRow varRow = (VariableIndexRow)this.variableIndex.readRow((int)pos);
            this.inputStream.seek(varRow.getOffset());
        } else {
            this.inputStream.seek((long)this.getAdjustedHeaderLength() + (pos - 1L) * (long)this.getRecordSize());
        }
    }

    public String toString() {
        return this.featureType.toString();
    }

    protected synchronized void unread(long bytes) throws IOException {
        this.inputStream.seek(this.inputStream.getFilePointer() - bytes);
    }

    private synchronized String getVariableIndexFileName() {
        String result = null;
        String fileName = this.getFileName();
        result = fileName.equalsIgnoreCase("FCS") ? this.getDirectoryName().concat(File.separator).concat("FCZ") : this.getDirectoryName().concat(File.separator).concat(fileName.substring(0, fileName.length() - 1) + "X");
        return result;
    }

    public VPFColumn getColumn(int index) {
        return this.columns.get(index);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public VPFColumn getColumn(String name) {
        if (name == null) {
            return null;
        }
        for (VPFColumn col : this.columns) {
            if (!name.equals(col.getName())) continue;
            return col;
        }
        return null;
    }

    public AttributeDescriptor getDescriptor(String name) {
        VPFColumn col = this.getColumn(name);
        return col == null ? null : col.getDescriptor();
    }
}

