/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.io;

import java.util.Map;
import org.geotools.data.vpf.ifc.VPFRow;
import org.geotools.data.vpf.io.RowField;

public class TableRow
implements VPFRow {
    private RowField[] fieldsArr = null;
    private Map<String, RowField> fieldsMap = null;

    public TableRow(RowField[] fieldsArr, Map<String, RowField> fieldsMap) {
        this.fieldsArr = fieldsArr;
        this.fieldsMap = fieldsMap;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.fieldsMap == null) {
            buff.append("null)");
        } else {
            for (RowField rowField : this.fieldsArr) {
                buff.append(rowField.toString() + ":");
            }
            buff.append(";");
        }
        return buff.toString();
    }

    public int fieldsCount() {
        return this.fieldsArr.length;
    }

    public RowField get(String name) {
        return this.fieldsMap.get(name);
    }

    public RowField get(int idx) {
        return this.fieldsArr[idx];
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TableRow)) {
            return false;
        }
        TableRow row = (TableRow)obj;
        if (this.fieldsArr == null && row.fieldsArr == null) {
            return true;
        }
        if (this.fieldsArr == null || row.fieldsArr == null) {
            return false;
        }
        if (this.fieldsArr.length != row.fieldsArr.length) {
            return false;
        }
        for (int i = 0; i < this.fieldsArr.length; ++i) {
            if (this.fieldsArr[i].equals(row.fieldsArr[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = 0;
        if (this.fieldsArr == null || this.fieldsArr.length == 0) {
            code = super.hashCode();
        } else {
            for (RowField rowField : this.fieldsArr) {
                code += rowField.hashCode();
            }
        }
        return code;
    }
}

