/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.io;

import org.geotools.data.vpf.VPFLogger;
import org.geotools.data.vpf.exc.VPFDataFormatException;

public class TripletId
extends Number {
    private static final long serialVersionUID = -3584133713173893007L;
    private byte[] rawData = null;

    public TripletId(byte[] data) {
        this.rawData = data;
    }

    public String toString() {
        String result = "";
        try {
            if (this.getIdLength() > 0) {
                result = Integer.valueOf(this.getId()).toString();
            }
            if (this.getTileIdLength() > 0) {
                result = result.concat("%").concat(Integer.valueOf(this.getTileId()).toString()).trim();
            }
            if (this.getNextIdLength() > 0) {
                result = result.concat("%").concat(Integer.valueOf(this.getNextId()).toString()).trim();
            }
        }
        catch (RuntimeException exp) {
            throw new VPFDataFormatException("This triplet is invalid.", exp);
        }
        return result;
    }

    private int getIdLength() {
        return this.rawData[0] >> 6 & 3;
    }

    private int getTileIdLength() {
        return this.rawData[0] >> 4 & 3;
    }

    private int getNextIdLength() {
        return this.rawData[0] >> 2 & 3;
    }

    public int getId() {
        int result = 0;
        int length = this.getIdLength();
        if (length > 0) {
            try {
                for (int inx = 0; inx < length; ++inx) {
                    int piece = this.rawData[inx + 1];
                    if (piece < 0) {
                        piece += 256;
                    }
                    result += piece << 8 * inx;
                }
            }
            catch (RuntimeException exp) {
                exp.printStackTrace();
                result = 0;
            }
        }
        return result;
    }

    public int getTileId() {
        int result = 0;
        int length = this.getTileIdLength();
        if (length > 0) {
            int rowIdLength = this.getIdLength();
            try {
                for (int inx = 0; inx < length; ++inx) {
                    int piece = this.rawData[inx + rowIdLength + 1];
                    if (piece < 0) {
                        piece += 254;
                    }
                    result += piece << 8 * inx;
                }
            }
            catch (RuntimeException exp) {
                exp.printStackTrace();
                result = 0;
            }
        }
        return result;
    }

    public int getNextId() {
        int result = 0;
        int length = this.getTileIdLength();
        if (length > 0) {
            int prevLength = this.getIdLength() + this.getTileIdLength();
            try {
                for (int inx = 0; inx < length; ++inx) {
                    int piece = this.rawData[inx + prevLength + 1];
                    if (piece < 0) {
                        piece += 254;
                    }
                    result += piece << 8 * inx;
                }
            }
            catch (RuntimeException exp) {
                exp.printStackTrace();
                result = 0;
            }
        }
        return result;
    }

    public static int calculateDataSize(byte definition) {
        int[] pieces = new int[]{definition >> 2 & 3, definition >> 4 & 3, definition >> 6 & 3};
        int size = 0;
        block6: for (int i = 0; i < pieces.length; ++i) {
            switch (pieces[i]) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    ++size;
                    continue block6;
                }
                case 2: {
                    size += 2;
                    continue block6;
                }
                case 3: {
                    size += 4;
                    continue block6;
                }
                default: {
                    VPFLogger.log("Tripled id size decoding error");
                    VPFLogger.log("tripled definition: " + definition);
                    VPFLogger.log("piece 0: " + pieces[0]);
                    VPFLogger.log("piece 1: " + pieces[1]);
                    VPFLogger.log("piece 2: " + pieces[2]);
                }
            }
        }
        return size;
    }

    @Override
    public double doubleValue() {
        return Integer.valueOf(this.getId()).doubleValue();
    }

    @Override
    public float floatValue() {
        return Integer.valueOf(this.getId()).floatValue();
    }

    @Override
    public int intValue() {
        return this.getId();
    }

    @Override
    public long longValue() {
        return Integer.valueOf(this.getId()).longValue();
    }

    @Override
    public byte byteValue() {
        return Integer.valueOf(this.getId()).byteValue();
    }

    @Override
    public short shortValue() {
        return Integer.valueOf(this.getId()).shortValue();
    }
}

