/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.file;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileStore;
import org.opengis.feature.simple.SimpleFeatureType;

public class VPFFileFactory
implements DataStoreFactorySpi {
    private VPFFileStore store = null;
    private static VPFFileFactory instance = null;
    public static final DataAccessFactory.Param FILE_PARAM = new DataAccessFactory.Param("file", File.class, "VPF file", true, null);

    private VPFFileFactory() {
    }

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        File file = (File)FILE_PARAM.lookUp(params);
        this.store = new VPFFileStore(file.getPath());
        return this.store;
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        throw new UnsupportedOperationException("Only existing data stores may be created.");
    }

    public String getDisplayName() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{FILE_PARAM};
    }

    public boolean canProcess(Map<String, Serializable> params) {
        try {
            String filePath = (String)FILE_PARAM.lookUp(params);
            if (filePath != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean isAvailable() {
        return true;
    }

    public static VPFFileFactory getInstance() {
        if (instance == null) {
            instance = new VPFFileFactory();
        }
        return instance;
    }

    public VPFFile getFile(String pathName) throws IOException {
        if (this.store == null) {
            this.store = new VPFFileStore(pathName);
        }
        this.store.getTypeSchema(pathName);
        SimpleFeatureType schema = this.store.getSchema(pathName);
        VPFFile file = (VPFFile)schema.getUserData().get(VPFFile.class);
        return file;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    public void reset() {
        this.store.reset();
    }
}

