/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.vpf.VPFCovFeatureSource;
import org.geotools.data.vpf.VPFCoverage;
import org.geotools.data.vpf.VPFFeatureClass;
import org.geotools.data.vpf.VPFFeatureSource;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.VPFLibFeatureSource;
import org.geotools.data.vpf.VPFLogger;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class VPFLibrary
extends ContentDataStore {
    private final double xmin;
    private final double ymin;
    private final double xmax;
    private final double ymax;
    private final File directory;
    private final String libraryName;
    private final List coverages = new Vector();
    private CoordinateReferenceSystem crs;
    private boolean loggedCRSException = false;
    private final Map<String, VPFFeatureType> typeMap = new HashMap<String, VPFFeatureType>();
    static URI DEFAULT_NAMESPACE;
    private URI namespace = DEFAULT_NAMESPACE;
    private final Map tileMap = new HashMap();

    public VPFLibrary(SimpleFeature libraryFeature, File dir, URI namespace) throws IOException, SchemaException {
        String vpfTableName = new File(dir, "LHT").toString();
        VPFFile lhtFile = VPFFileFactory.getInstance().getFile(vpfTableName);
        lhtFile.reset();
        this.namespace = namespace != null ? namespace : DEFAULT_NAMESPACE;
        try {
            lhtFile.readFeature();
        }
        catch (IllegalAttributeException exc) {
            exc.printStackTrace();
            throw new IOException("Illegal values in library attribute table");
        }
        if (libraryFeature != null) {
            this.xmin = ((Number)libraryFeature.getAttribute("xmin")).doubleValue();
            this.ymin = ((Number)libraryFeature.getAttribute("ymin")).doubleValue();
            this.xmax = ((Number)libraryFeature.getAttribute("xmax")).doubleValue();
            this.ymax = ((Number)libraryFeature.getAttribute("ymax")).doubleValue();
        } else {
            this.xmin = -180.0;
            this.ymin = -90.0;
            this.xmax = 180.0;
            this.ymax = 90.0;
        }
        this.directory = dir;
        String directoryName = this.directory.getPath();
        this.libraryName = directoryName.substring(directoryName.lastIndexOf(File.separator) + 1);
        this.setCoverages();
    }

    private void setCoverages() throws IOException, SchemaException {
        boolean debug = VPFLogger.isLoggable(Level.FINEST);
        if (debug) {
            VPFLogger.log("+++++++++++++ setCoverages: " + this.directory);
        }
        if (!this.directory.getName().equals("RFERENCE")) {
            String vpfTableName = new File(this.directory, "CAT").toString();
            VPFFile vpfFile = VPFFileFactory.getInstance().getFile(vpfTableName);
            if (debug) {
                VPFLogger.log("vpfTableName: " + vpfTableName);
                VPFLogger.log("vpfRootPathName: " + vpfFile.getPathName());
            }
            for (SimpleFeature feature : vpfFile.readAllRows()) {
                String directoryName = this.directory.getPath();
                VPFCoverage coverage = new VPFCoverage(this, feature, directoryName, this.namespace);
                this.coverages.add(coverage);
                String coverageName = coverage.getName();
                if (coverageName.equalsIgnoreCase("TILEREF")) {
                    this.createTilingSchema(coverage);
                }
                if (debug) {
                    VPFLogger.log("---------- coverageName: " + coverageName);
                    VPFLogger.log(coverage.getPathName());
                    VPFLogger.log(coverage.getDescription());
                }
                List featureTypes = coverage.getFeatureTypes();
                for (int ift = 0; ift < featureTypes.size(); ++ift) {
                    VPFFeatureType featureType = (VPFFeatureType)featureTypes.get(ift);
                    VPFFeatureClass featureClass = featureType.getFeatureClass();
                    String featureTypeName = featureType.getTypeName();
                    if (debug) {
                        VPFLogger.log(">>>>>featureType: " + featureTypeName);
                        VPFLogger.log("     directory:   " + featureType.getDirectoryName());
                        VPFLogger.log("     fc type  :   " + featureClass.getFCTypeName());
                    }
                    this.typeMap.put(featureTypeName, featureType);
                    List<VPFFile> fileList = featureClass.getFileList();
                    if (debug) {
                        VPFLogger.log("   file count :   " + fileList.size());
                    }
                    for (int ifl = 0; ifl < fileList.size(); ++ifl) {
                        VPFFile vpfClassFile = fileList.get(ifl);
                        if (!debug) continue;
                        if (vpfClassFile == null) {
                            VPFLogger.log("null");
                            continue;
                        }
                        VPFLogger.log(vpfClassFile.getPathName());
                    }
                }
            }
        }
    }

    public List getCoverages() {
        return this.coverages;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public String toString() {
        return String.format("{library: \"%s\",xmin: %f,xmax: %f,ymin: %f,ymax: %f}", this.libraryName, this.getXmin(), this.getXmax(), this.getYmin(), this.getYmax());
    }

    public Map getTileMap() {
        return this.tileMap;
    }

    private void createTilingSchema(VPFCoverage coverage) throws IOException {
        VPFFeatureType tileType = (VPFFeatureType)coverage.getFeatureTypes().get(0);
        List<SimpleFeature> allFeatures = tileType.readAllRows();
        for (SimpleFeature row : allFeatures) {
            Short rowId = Short.parseShort(row.getAttribute("id").toString());
            String value = row.getAttribute("tile_name").toString();
            String[] tmp = value.split("\\\\");
            value = tmp[0];
            int ii = tmp.length;
            for (int i = 1; i < ii; ++i) {
                value = value.concat(File.separator).concat(tmp[i]);
            }
            this.tileMap.put(rowId, value);
        }
    }

    public List<Name> getNames() {
        int inx;
        ArrayList<Name> result = new ArrayList<Name>();
        int coveragesCount = this.coverages.size();
        int featureTypesCount = 0;
        List[] coverageTypes = new List[coveragesCount];
        for (inx = 0; inx < coveragesCount; ++inx) {
            coverageTypes[inx] = ((VPFCoverage)this.coverages.get(inx)).getFeatureTypes();
            featureTypesCount += coverageTypes[inx].size();
        }
        for (inx = 0; inx < coveragesCount; ++inx) {
            for (int jnx = 0; jnx < coverageTypes[inx].size(); ++jnx) {
                SimpleFeatureType featureType = (SimpleFeatureType)coverageTypes[inx].get(jnx);
                String featureTypeName = featureType.getTypeName();
                NameImpl name = new NameImpl(featureTypeName);
                result.add((Name)name);
            }
        }
        return result;
    }

    public VPFFeatureType getFeatureType(ContentEntry entry) throws IOException {
        String typeName = entry.getTypeName();
        return (VPFFeatureType)this.getTypeSchema(typeName);
    }

    protected List<Name> createTypeNames() throws IOException {
        return this.getNames();
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        String typeName = entry.getTypeName();
        if (typeName == null) {
            return null;
        }
        return this.getFeatureSource(typeName);
    }

    public ContentFeatureSource getFeatureSource(Name typeName, Transaction tx) throws IOException {
        String localTypeName = typeName.getLocalPart();
        return super.getFeatureSource((Name)new NameImpl(localTypeName), tx);
    }

    public ContentFeatureSource getFeatureSource(String typeName) throws IOException {
        VPFFeatureSource featureSource = VPFFeatureSource.getFeatureSource(typeName);
        if (featureSource == null) {
            featureSource = VPFFeatureSource.getFeatureSource(typeName.toUpperCase());
        }
        if (featureSource == null) {
            VPFFeatureType featureType = this.typeMap.get(typeName);
            if (featureType == null) {
                featureType = this.typeMap.get(typeName.toUpperCase());
            }
            if (featureType != null) {
                String featureTypeName = featureType.getTypeName();
                Query query = new Query(Query.ALL);
                ContentEntry entry = this.entry((Name)new NameImpl(featureTypeName));
                featureSource = new VPFCovFeatureSource(featureType, entry, query);
            }
        }
        if (featureSource == null) {
            if (VPFLogger.isLoggable(Level.FINEST)) {
                VPFLogger.log("VPFLibrary.getFeatureSource returned null");
                VPFLogger.log(typeName);
            }
            Query query = new Query(Query.ALL);
            ContentEntry entry = this.entry((Name)new NameImpl(typeName));
            featureSource = new VPFLibFeatureSource(entry, query);
        }
        return featureSource;
    }

    public File getDirectory() {
        return this.directory;
    }

    public SimpleFeatureType getTypeSchema(String typeName) throws IOException {
        SimpleFeatureType result = null;
        Iterator coverageIter = this.coverages.iterator();
        boolean breakOut = false;
        block0: while (coverageIter.hasNext() && !breakOut) {
            for (SimpleFeatureType temp : ((VPFCoverage)coverageIter.next()).getFeatureTypes()) {
                if (!temp.getTypeName().equals(typeName)) continue;
                result = temp;
                breakOut = true;
                continue block0;
            }
        }
        return result;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        block4: {
            if (this.crs == null) {
                try {
                    String geoDatumCode;
                    String vpfTableName = new File(this.directory, "GRT").toString();
                    VPFFile grtFile = VPFFileFactory.getInstance().getFile(vpfTableName);
                    SimpleFeature grt = grtFile.getRowFromId("id", 1);
                    String dataType = String.valueOf(grt.getAttribute("data_type"));
                    if ("GEO".equalsIgnoreCase(dataType) && "WGE".equalsIgnoreCase(geoDatumCode = String.valueOf(grt.getAttribute("geo_datum_code")))) {
                        this.crs = DefaultGeographicCRS.WGS84;
                    }
                }
                catch (Exception ex) {
                    if (this.loggedCRSException) break block4;
                    ex.printStackTrace();
                    this.loggedCRSException = true;
                }
            }
        }
        return this.crs;
    }

    static {
        try {
            DEFAULT_NAMESPACE = new URI("http://www.vpf.org/default");
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException("programmer error making default uri");
        }
    }
}

