/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.VPFLibrary;
import org.geotools.data.vpf.VPFLogger;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.feature.SchemaException;
import org.geotools.util.KVP;
import org.opengis.feature.simple.SimpleFeature;

public class VPFDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param DIR = new DataAccessFactory.Param("url", URL.class, "Directory containing lht file", true);
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false);

    public String getDisplayName() {
        return "Vector Product Format Library";
    }

    public String getDescription() {
        return "Vector Product Format Library data store implementation.";
    }

    public boolean canProcess(Map params) {
        boolean result = false;
        try {
            this.getLhtFile(params);
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public DataStore createDataStore(Map params) throws IOException {
        return this.create(params);
    }

    public DataStore createDataStore(URL url) throws IOException {
        KVP params = new KVP(new Object[]{"url", url});
        return this.createDataStore((Map)params);
    }

    private DataStore create(Map params) throws IOException {
        VPFFile latTable;
        Iterator<SimpleFeature> iter;
        VPFLibrary result = null;
        File file = this.getLhtFile(params);
        if (!file.exists() || !file.canRead()) {
            throw new IOException("File either doesn't exist or is unreadable : " + file);
        }
        URI namespace = (URI)NAMESPACEP.lookUp(params);
        boolean debug = VPFLogger.isLoggable(Level.FINEST);
        Path lhtPath = Paths.get(file.getPath(), new String[0]);
        Path lhtRealPath = lhtPath.toRealPath(new LinkOption[0]);
        Path lhtParentPath = lhtRealPath.getParent();
        if (lhtParentPath == null) {
            throw new IOException("Fileparent either doesn't exist or is unreadable : " + lhtRealPath);
        }
        String rootDir = lhtParentPath.toString();
        String latTableName = new File(rootDir, "LAT").toString();
        if (debug) {
            VPFLogger.log("open vpf datastore with params: " + params);
            VPFLogger.log("vpf datastore path: " + file.getPath());
            VPFLogger.log("LAT path: " + latTableName);
        }
        SimpleFeature feature = (iter = (latTable = VPFFileFactory.getInstance().getFile(latTableName)).readAllRows().iterator()).hasNext() ? iter.next() : null;
        String directoryName = file.getPath();
        String folderName = directoryName.substring(directoryName.lastIndexOf(File.separator) + 1);
        SimpleFeature libraryFeature = null;
        while (feature != null) {
            String libraryName = feature.getAttribute("library_name").toString();
            if (libraryName.equalsIgnoreCase(folderName)) {
                libraryFeature = feature;
                if (!debug) break;
                VPFLogger.log("found library feature: " + folderName);
                break;
            }
            if (VPFLogger.isLoggable(Level.FINEST)) {
                VPFLogger.log("----------- LAT feature: " + feature.getID());
                VPFFeatureType.debugFeature(feature);
            }
            feature = iter.hasNext() ? iter.next() : null;
        }
        try {
            result = new VPFLibrary(libraryFeature, file, namespace);
        }
        catch (SchemaException exc) {
            throw new IOException("There was a problem making one of the feature classes as a FeatureType.");
        }
        return result;
    }

    private File getLhtFile(Map params) throws IOException {
        URL url = (URL)DIR.lookUp(params);
        File file = null;
        if (url.getProtocol().equals("file")) {
            file = url.getHost() != null && !url.getHost().equals("") ? new File(url.getHost() + ":" + url.getFile()) : new File(url.getFile());
            if (file.isDirectory()) {
                file = new File(file, "LHT");
            } else if (!file.getName().equalsIgnoreCase("LHT")) {
                throw new IOException("File: " + file + "is not a lht file");
            }
        } else {
            throw new IOException("only file protocol supported");
        }
        return file;
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        return this.create(params);
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{DIR};
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }
}

