/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.readers;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.geotools.data.vpf.VPFFeatureClass;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.VPFLibrary;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.readers.VPFGeometryFactory;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;

public class LineGeometryFactory
extends VPFGeometryFactory
implements FileConstants {
    @Override
    public synchronized void createGeometry(VPFFeatureType featureType, SimpleFeature values) throws SQLException, IOException, IllegalAttributeException {
        Geometry result = this.buildGeometry(featureType.getFeatureClass(), values);
        values.setDefaultGeometry((Object)result);
    }

    @Override
    public synchronized Geometry buildGeometry(VPFFeatureClass featureClass, SimpleFeature values) throws SQLException, IOException, IllegalAttributeException {
        int edgeId = Integer.parseInt(values.getAttribute("edg_id").toString());
        String baseDirectory = featureClass.getDirectoryName();
        String tileDirectory = baseDirectory;
        if (!new File(tileDirectory.concat(File.separator).concat("EDG")).exists()) {
            Short tileId = Short.parseShort(values.getAttribute("tile_id").toString());
            VPFLibrary vpf = featureClass.getCoverage().getLibrary();
            String tileName = vpf.getTileMap().get(tileId);
            if (tileName != null) {
                tileDirectory = tileDirectory.concat(File.separator).concat(tileName.toUpperCase()).trim();
            }
        }
        if (!new File(tileDirectory.concat(File.separator).concat("EDG")).exists()) {
            return null;
        }
        String edgeTableName = tileDirectory.concat(File.separator).concat("EDG");
        VPFFile edgeFile = VPFFileFactory.getInstance().getFile(edgeTableName);
        SimpleFeature row = edgeFile.getRowFromId("id", edgeId);
        Geometry result = (Geometry)row.getAttribute("coordinates");
        return result;
    }
}

