/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.store.ContentState;
import org.geotools.data.vpf.VPFColumn;
import org.geotools.data.vpf.VPFFeatureClass;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.file.VPFFile;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;

public class VPFFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private boolean resetCalled = false;
    private SimpleFeature currentFeature = null;
    private final VPFFeatureType featureType;
    protected ContentState state;

    public VPFFeatureReader(VPFFeatureType type) {
        this.featureType = type;
    }

    public VPFFeatureReader(ContentState contentState, VPFFeatureType featureType) throws IOException {
        this.state = contentState;
        this.featureType = featureType;
    }

    public synchronized void close() throws IOException {
        this.reset();
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public synchronized boolean hasNext() throws IOException {
        VPFFeatureClass featureClass = this.featureType.getFeatureClass();
        if (!this.resetCalled) {
            this.reset();
        }
        return featureClass.hasNext();
    }

    public synchronized SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        this.readNext();
        return this.currentFeature;
    }

    private synchronized boolean readNext() throws IOException {
        VPFFeatureClass featureClass = this.featureType.getFeatureClass();
        if (!this.resetCalled) {
            this.reset();
        }
        this.currentFeature = featureClass.readNext(this.featureType);
        return this.currentFeature != null;
    }

    public synchronized VPFFile getVPFFile(VPFColumn column) {
        String columnName = column.getName();
        VPFFile result = null;
        for (VPFFile temp : this.featureType.getFeatureClass().getFileList()) {
            if (temp == null || temp.getColumn(columnName) == null) continue;
            result = temp;
            break;
        }
        return result;
    }

    public synchronized VPFFile getVPFFile(AttributeDescriptor column) {
        Name columnName = column.getName();
        VPFFile result = null;
        for (VPFFile temp : this.featureType.getFeatureClass().getFileList()) {
            if (temp == null || temp.getColumn(columnName.getLocalPart()) == null) continue;
            result = temp;
            break;
        }
        return result;
    }

    public synchronized void reset() {
        VPFFeatureClass featureClass = this.featureType.getFeatureClass();
        featureClass.reset();
        this.resetCalled = true;
    }
}

