/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.vpf.VPFFeatureReader;
import org.geotools.data.vpf.VPFFeatureSource;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class VPFCovFeatureSource
extends VPFFeatureSource {
    private VPFFeatureType featureType;

    public VPFCovFeatureSource(VPFFeatureType featureType, ContentEntry entry, Query query) {
        super(entry, query);
        this.featureType = featureType;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new VPFFeatureReader(this.getState(), this.featureType);
    }

    protected int getCountInternal(Query query) throws IOException {
        return -1;
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        CoordinateReferenceSystem crs = this.featureType.getCoordinateReferenceSystem();
        ReferencedEnvelope bounds = null;
        try (FeatureReader rdr = this.getReader();){
            while (rdr.hasNext()) {
                SimpleFeature feature = (SimpleFeature)rdr.next();
                if (feature == null) continue;
                BoundingBox bb = feature.getBounds();
                if (bounds == null) {
                    bounds = new ReferencedEnvelope(bb);
                    continue;
                }
                bounds.expandToInclude((org.locationtech.jts.geom.Envelope)ReferencedEnvelope.reference((Envelope)bb));
            }
        }
        if (bounds == null) {
            bounds = ReferencedEnvelope.create((CoordinateReferenceSystem)crs);
        }
        return bounds;
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.featureType;
    }
}

