/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vectormosaic;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;

public class VectorMosaicPostPreFilterSplitter
extends PostPreProcessFilterSplittingVisitor {
    private Set<String> attributeNames = new HashSet<String>();

    public VectorMosaicPostPreFilterSplitter(SimpleFeatureType featureType) {
        super(null, null, null);
        List indexAttributeDescriptors = featureType.getAttributeDescriptors();
        indexAttributeDescriptors.stream().map(AttributeDescriptor::getLocalName).forEach(this.attributeNames::add);
        this.attributeNames.add("");
    }

    private boolean containsAll(Filter filter) {
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        filter.accept((FilterVisitor)extractor, null);
        return this.attributeNames.containsAll(extractor.getAttributeNameSet());
    }

    protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter) {
        if (!this.containsAll((Filter)filter)) {
            this.postStack.push(filter);
            return;
        }
        super.visitBinaryComparisonOperator(filter);
    }

    protected void visitBinarySpatialOperator(BinarySpatialOperator filter) {
        if (!this.containsAll((Filter)filter)) {
            this.postStack.push(filter);
            return;
        }
        super.visitBinarySpatialOperator(filter);
    }

    protected Object visit(BinaryTemporalOperator filter, Object data) {
        if (!this.containsAll((Filter)filter)) {
            this.postStack.push(filter);
            return data;
        }
        return super.visit(filter, data);
    }

    public Object visit(BBOX filter, Object extraData) {
        if (!this.containsAll((Filter)filter)) {
            this.postStack.push(filter);
            return extraData;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsLike likeFilter, Object extraData) {
        if (!this.containsAll((Filter)likeFilter)) {
            this.postStack.push(likeFilter);
            return extraData;
        }
        return super.visit(likeFilter, extraData);
    }

    public Object visit(PropertyIsBetween betweenFilter, Object extraData) {
        if (!this.containsAll((Filter)betweenFilter)) {
            this.postStack.push(betweenFilter);
            return extraData;
        }
        return super.visit(betweenFilter, extraData);
    }

    public Object visit(ExcludeFilter excludeFilter, Object extraData) {
        if (!this.containsAll((Filter)excludeFilter)) {
            this.postStack.push(excludeFilter);
            return extraData;
        }
        return super.visit(excludeFilter, extraData);
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        if (!this.containsAll((Filter)filter)) {
            this.postStack.push(filter);
            return extraData;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        if (!this.containsAll((Filter)filter)) {
            this.postStack.push(filter);
            return extraData;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(Id filter, Object extraData) {
        if (!this.containsAll((Filter)filter)) {
            this.postStack.push(filter);
            return extraData;
        }
        return super.visit(filter, extraData);
    }

    protected boolean supports(Object value) {
        return true;
    }
}

