/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vectormosaic;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.Repository;
import org.geotools.api.feature.type.Name;
import org.geotools.data.store.DecoratingDataStore;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.geotools.vectormosaic.GranuleStoreFinder;
import org.geotools.vectormosaic.VectorMosaicGranule;

public class GranuleStoreFinderImpl
extends GranuleStoreFinder {
    static final Logger LOGGER = Logging.getLogger(GranuleStoreFinderImpl.class);
    protected final String preferredSPI;
    protected final Repository repository;

    public GranuleStoreFinderImpl(String preferredSPI, Repository repository) {
        this.preferredSPI = preferredSPI;
        this.repository = repository;
    }

    @Override
    public Optional<DataStore> findDataStore(VectorMosaicGranule granule, boolean isSampleForSchema) {
        DataStore dataStore = null;
        try {
            if (granule.getStoreName() != null) {
                Object ds = this.repository.dataStore((Name)new NameImpl(granule.getStoreName()));
                if (ds != null) {
                    ds = new DisposeStopWrapper((DataStore)ds);
                }
                return Optional.ofNullable(ds);
            }
            if (granule.getConnProperties() != null) {
                Map params = this.propertiesToMap(granule.getConnProperties());
                if (this.preferredSPI != null) {
                    DataStoreFactorySpi dataStoreFactorySpi = this.getSPI(this.preferredSPI);
                    dataStore = dataStoreFactorySpi.createDataStore(params);
                } else {
                    dataStore = DataStoreFinder.getDataStore((Map)params);
                }
                LOGGER.log(Level.FINE, "Found and set datastore for granule {0} with params {1}", new Object[]{granule.getName(), granule.getConnProperties()});
                if (!isSampleForSchema && this.granuleTracker != null) {
                    this.granuleTracker.add(granule.getParams());
                }
            } else {
                LOGGER.log(Level.WARNING, "Connection properties not found for Vector Mosaic granule {0}", granule.getName());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not find data store", e);
        }
        return Optional.ofNullable(dataStore);
    }

    public String getPreferredSPI() {
        return this.preferredSPI;
    }

    private class DisposeStopWrapper
    extends DecoratingDataStore {
        public DisposeStopWrapper(DataStore ds) {
            super(ds);
        }

        public void dispose() {
        }
    }
}

