/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vectormosaic;

import java.io.IOException;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.Repository;
import org.geotools.util.KVP;
import org.geotools.vectormosaic.VectorMosaicStore;

public class VectorMosaicStoreFactory
implements DataStoreFactorySpi {
    private static final String DISPLAY_NAME = "Vector Mosaic Data Store";
    private static final String DESCRIPTION = "Creates Vector Mosaic from multiple sources";
    public static final DataAccessFactory.Param REPOSITORY_PARAM = new DataAccessFactory.Param("repository", Repository.class, "The repository that will provide the store intances", true, null, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "Namespace prefix", false);
    public static final DataAccessFactory.Param DELEGATE_STORE_NAME = new DataAccessFactory.Param("delegateStoreName", String.class, "The name of the delegate store.  The delegate store must point to vector features with the same attributes/schema.", true);
    public static final DataAccessFactory.Param PREFERRED_DATASTORE_SPI = new DataAccessFactory.Param("preferredDataStoreSPI", String.class, "The preferred DataStoreSPI to test connection parameters against. If not specified, the first DataStoreSPI found that accepts connection parameters will be used. Default is org.geotools.data.shapefile.ShapefileDataStoreFactory", false);
    public static final DataAccessFactory.Param CONNECTION_PARAMETER_KEY = new DataAccessFactory.Param("connectionParameterKey", String.class, "The key to use for the connection parameter.  Default is 'url'", false);

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        Repository repository = this.lookup(REPOSITORY_PARAM, params, Repository.class);
        String namespace = this.lookup(NAMESPACE, params, String.class);
        String delegateStoreName = this.lookup(DELEGATE_STORE_NAME, params, String.class);
        String preferredDataStoreSPI = this.lookup(PREFERRED_DATASTORE_SPI, params, String.class);
        String connectionParameterKey = this.lookup(CONNECTION_PARAMETER_KEY, params, String.class);
        VectorMosaicStore vectorMosaicStore = new VectorMosaicStore(delegateStoreName, repository);
        vectorMosaicStore.setNamespaceURI(namespace);
        if (preferredDataStoreSPI != null) {
            vectorMosaicStore.setPreferredSPI(preferredDataStoreSPI);
        }
        if (connectionParameterKey != null) {
            vectorMosaicStore.setConnectionParameterKey(connectionParameterKey);
        }
        return vectorMosaicStore;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{REPOSITORY_PARAM, NAMESPACE, DELEGATE_STORE_NAME, CONNECTION_PARAMETER_KEY, PREFERRED_DATASTORE_SPI};
    }

    public boolean isAvailable() {
        return true;
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        throw new UnsupportedOperationException();
    }

    private <T> T lookup(DataAccessFactory.Param param, Map<String, ?> params, Class<T> target) throws IOException {
        Object result = param.lookUp(params);
        if (result == null) {
            return (T)param.getDefaultValue();
        }
        return (T)result;
    }
}

