/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vectormosaic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.vectormosaic.GranuleTracker;
import org.geotools.vectormosaic.VectorMosaicGranule;

public abstract class GranuleStoreFinder {
    protected GranuleTracker granuleTracker;

    public abstract Optional<DataStore> findDataStore(VectorMosaicGranule var1, boolean var2);

    protected Map propertiesToMap(Properties connProps) {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        for (Object key : connProps.keySet()) {
            params.put(key, connProps.get(key));
        }
        return params;
    }

    protected DataStoreFactorySpi getSPI(String preferredSPI) {
        DataStoreFactorySpi dataStoreFactorySpi = null;
        Iterator it = DataStoreFinder.getAvailableDataStores();
        while (it.hasNext()) {
            DataStoreFactorySpi spi = (DataStoreFactorySpi)it.next();
            if (!spi.getClass().getTypeName().equals(preferredSPI)) continue;
            dataStoreFactorySpi = spi;
            break;
        }
        return dataStoreFactorySpi;
    }
}

