/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vectormosaic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.data.DataStore;
import org.geotools.data.Repository;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentState;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.geotools.vectormosaic.VectorMosaicFeatureSource;
import org.geotools.vectormosaic.VectorMosaicState;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;

public class VectorMosaicStore
extends ContentDataStore {
    static final Logger LOGGER = Logging.getLogger(VectorMosaicStore.class);
    private final Repository repository;
    private final String delegateStoreName;
    private String preferredSPI;
    public static final String CONNECTION_PARAMETER_KEY_URL = "url";
    public static final String CONNECTION_PARAMETER_KEY_FILE = "file";
    private String connectionParameterKey = "url";
    public static final String MOSAIC_TYPE_SUFFIX = "_mosaic";
    private static final String POLYGON_TYPE_NAME = "org.locationtech.jts.geom.Polygon";
    private static final String MULTI_POLYGON_TYPE_NAME = "org.locationtech.jts.geom.MultiPolygon";

    public String getDelegateStoreName() {
        return this.delegateStoreName;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getConnectionParameterKey() {
        return this.connectionParameterKey;
    }

    public void setConnectionParameterKey(String connectionParameterKey) {
        this.connectionParameterKey = connectionParameterKey;
    }

    public String getPreferredSPI() {
        return this.preferredSPI;
    }

    public void setPreferredSPI(String preferredSPI) {
        this.preferredSPI = preferredSPI;
    }

    public VectorMosaicStore(String delegateStoreName, Repository repository) {
        this.repository = repository;
        this.delegateStoreName = delegateStoreName;
    }

    private boolean validateSchema(String delegateStoreName, String typeName, SimpleFeatureType delegateSchema) {
        if (delegateSchema.getDescriptor("params") == null) {
            LOGGER.log(Level.INFO, "Delegate store " + delegateStoreName + " schema with type name " + typeName + " does not contain required field params");
            return false;
        }
        if (delegateSchema.getGeometryDescriptor() == null) {
            LOGGER.log(Level.INFO, "Delegate store " + delegateStoreName + " schema with type name " + typeName + " does not contain a geometry field");
            return false;
        }
        GeometryType geometryType = delegateSchema.getGeometryDescriptor().getType();
        if (geometryType != null && geometryType.getBinding() != null && !geometryType.getBinding().isAssignableFrom(GeometryType.class)) {
            String geometryTypeName = geometryType.getBinding().getName();
            if (!geometryTypeName.equals(POLYGON_TYPE_NAME) && !geometryTypeName.equals(MULTI_POLYGON_TYPE_NAME)) {
                LOGGER.log(Level.INFO, "Delegate store " + delegateStoreName + " schema with type name " + typeName + " contains geometry but is not a polygon or multipolygon");
                return false;
            }
        } else {
            LOGGER.log(Level.INFO, "Delegate store " + delegateStoreName + " schema with type name " + typeName + " does not contain a valid geometry field");
            return false;
        }
        return true;
    }

    public static Name buildName(String name) {
        int idx = name.indexOf(":");
        if (idx == -1) {
            return new NameImpl(name);
        }
        String ns = name.substring(0, idx);
        String local = name.substring(idx + 1);
        return new NameImpl(ns, local);
    }

    protected List<Name> createTypeNames() throws IOException {
        Name dsname = VectorMosaicStore.buildName(this.delegateStoreName);
        DataStore delegateDataStore = this.repository.dataStore(dsname);
        if (delegateDataStore == null) {
            throw new IOException("Could not find delegate store " + this.delegateStoreName);
        }
        List delegateTypes = null;
        try {
            delegateTypes = Arrays.stream(delegateDataStore.getTypeNames()).filter(t -> {
                try {
                    return this.validateSchema(this.delegateStoreName, (String)t, delegateDataStore.getSchema(t));
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to validate schema for type " + t, e);
                    return false;
                }
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to get type names for vector mosaic delegate data store " + this.delegateStoreName, e);
        }
        ArrayList<Name> result = new ArrayList<Name>();
        if (delegateTypes != null) {
            for (String delegateName : delegateTypes) {
                result.add(VectorMosaicStore.buildName(delegateName + MOSAIC_TYPE_SUFFIX));
            }
        }
        return result;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        String name = entry.getName().getLocalPart();
        if (!Arrays.stream(this.getTypeNames()).anyMatch(name::equals)) {
            throw new IOException("No Vector Mosaic configuration found for type " + name);
        }
        return new VectorMosaicFeatureSource(entry, this);
    }

    protected ContentState createContentState(ContentEntry entry) {
        return new VectorMosaicState(entry);
    }
}

