/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vectormosaic;

import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.util.logging.Logging;
import org.geotools.vectormosaic.VectorMosaicFeatureSource;
import org.geotools.vectormosaic.VectorMosaicGranule;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;

class GranuleSourceProvider
implements Closeable {
    static final Logger LOGGER = Logging.getLogger(GranuleSourceProvider.class);
    private final VectorMosaicFeatureSource source;
    private final Query query;
    private final SimpleFeatureIterator delegateIterator;
    DataStore granuleDataStore;
    String params;
    protected SimpleFeature delegateFeature = null;
    private Query granuleQuery;

    GranuleSourceProvider(VectorMosaicFeatureSource source, SimpleFeatureCollection delegateCollection, Query query) {
        this.source = source;
        this.query = query;
        this.delegateIterator = delegateCollection.features();
    }

    private Filter getGranuleFilter(VectorMosaicGranule granule) {
        Filter filter = this.source.getSplitFilter(this.query, this.granuleDataStore, granule.getGranuleTypeName(), false);
        Filter configuredFilter = granule.getFilter();
        if (configuredFilter != null && configuredFilter != Filter.INCLUDE) {
            FilterFactory ff = this.source.getDataStore().getFilterFactory();
            return ff.and(filter, configuredFilter);
        }
        return filter;
    }

    public SimpleFeatureSource getNextGranuleSource() throws IOException {
        if (this.delegateIterator.hasNext()) {
            this.delegateFeature = (SimpleFeature)this.delegateIterator.next();
            VectorMosaicGranule granule = VectorMosaicGranule.fromDelegateFeature(this.delegateFeature);
            if (this.source.finder.granuleTracker != null) {
                this.source.finder.granuleTracker.incrementAccessCount();
            }
            if (this.params != null && this.params.equals(granule.getParams())) {
                this.source.populateGranuleTypeName(granule, this.granuleDataStore);
            } else {
                if (this.granuleDataStore != null) {
                    this.granuleDataStore.dispose();
                }
                this.granuleDataStore = this.source.initGranule(granule, false);
                this.params = granule.getParams();
            }
            Filter granuleFilter = this.getGranuleFilter(granule);
            this.granuleQuery = new Query(granule.getGranuleTypeName(), granuleFilter);
            if (this.query.getPropertyNames() != Query.ALL_NAMES) {
                String[] filteredArray = VectorMosaicFeatureSource.getOnlyTypeMatchingAttributes(this.granuleDataStore, granule.getGranuleTypeName(), this.query, false);
                this.granuleQuery.setPropertyNames(filteredArray);
            }
            if (this.query.getMaxFeatures() != Integer.MAX_VALUE) {
                this.granuleQuery.setMaxFeatures(this.query.getMaxFeatures());
            }
            return this.granuleDataStore.getFeatureSource(granule.getGranuleTypeName());
        }
        return null;
    }

    public Query getQuery() {
        return this.query;
    }

    public Query getGranuleQuery() {
        return this.granuleQuery;
    }

    public SimpleFeature getDelegateFeature() {
        return this.delegateFeature;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.delegateIterator != null) {
                this.delegateIterator.close();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to close delegate iterator", e);
        }
        if (this.granuleDataStore != null) {
            this.granuleDataStore.dispose();
        }
    }
}

