/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.xml;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.filter.FilterDOMParser;
import org.geotools.gml.producer.GeometryTransformer;
import org.geotools.validation.xml.ReaderUtils;
import org.geotools.validation.xml.ValidationException;
import org.geotools.xml.filter.FilterTransformer;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ArgHelper {
    private static final Mapping[] argumentTypeMappings = new Mapping[]{new FilterMapping(), new GeometryMapping(), new EnvelopeMapping(), new ShortMapping(), new IntegerMapping(), new LongMapping(), new FloatMapping(), new DoubleMapping(), new DateMapping(), new URIMapping(), new BooleanMapping(), new StringMapping()};
    public static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();

    public static Object getArgumentInstance(String elementName, Element value) throws ValidationException {
        if (elementName == null) {
            throw new NullPointerException("A Typename must be specified.");
        }
        for (int i = 0; i < argumentTypeMappings.length; ++i) {
            if (!elementName.equals(argumentTypeMappings[i].getElementName())) continue;
            return argumentTypeMappings[i].getInstance(value);
        }
        return null;
    }

    public static Object getArgumentInstance(String elementName, String value) throws ValidationException {
        if (elementName == null) {
            throw new NullPointerException("A Typename must be specified.");
        }
        for (int i = 0; i < argumentTypeMappings.length; ++i) {
            if (!elementName.equals(argumentTypeMappings[i].getType())) continue;
            return argumentTypeMappings[i].getInstance(value);
        }
        return null;
    }

    public static String getArgumentType(Object o) {
        if (o == null) {
            throw new NullPointerException("An argument instance must be specified.");
        }
        if (o instanceof Class) {
            for (int i = 0; i < argumentTypeMappings.length; ++i) {
                if (!argumentTypeMappings[i].isClass((Class)o)) continue;
                return argumentTypeMappings[i].getType();
            }
        } else {
            for (int i = 0; i < argumentTypeMappings.length; ++i) {
                if (!argumentTypeMappings[i].isClassInstance(o)) continue;
                return argumentTypeMappings[i].getType();
            }
        }
        return "";
    }

    public static String getArgumentEncoding(Object o) throws ValidationException {
        if (o == null) {
            throw new NullPointerException("An argument instance must be specified.");
        }
        for (int i = 0; i < argumentTypeMappings.length; ++i) {
            if (!argumentTypeMappings[i].isClassInstance(o)) continue;
            return argumentTypeMappings[i].encode(o);
        }
        return "";
    }

    public static String getArgumentStringEncoding(Object o) {
        if (o == null) {
            throw new NullPointerException("An argument instance must be specified.");
        }
        for (int i = 0; i < argumentTypeMappings.length; ++i) {
            if (!argumentTypeMappings[i].isClassInstance(o)) continue;
            return argumentTypeMappings[i].toString(o);
        }
        return "";
    }

    protected static class StringMapping
    implements Mapping {
        protected StringMapping() {
        }

        @Override
        public String getType() {
            return "xs:string";
        }

        @Override
        public String getElementName() {
            return "string";
        }

        @Override
        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The string passed in was null");
            }
            return ReaderUtils.getElementText(elem);
        }

        @Override
        public Object getInstance(String value) {
            if (value == null) {
                throw new NullPointerException("The string passed in was null");
            }
            return value;
        }

        @Override
        public boolean isClassInstance(Object c) {
            return c != null && c instanceof String;
        }

        @Override
        public boolean isClass(Class c) {
            return c != null && String.class.equals((Object)c);
        }

        @Override
        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The string obj passed in was null");
            }
            if (!(obj instanceof String)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            return "<string>" + ((String)obj).toString() + "</string>\n";
        }

        @Override
        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class BooleanMapping
    implements Mapping {
        protected BooleanMapping() {
        }

        @Override
        public String getType() {
            return "xs:boolean";
        }

        @Override
        public String getElementName() {
            return "boolean";
        }

        @Override
        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The boolean passed in was null");
            }
            return Boolean.valueOf(ReaderUtils.getElementText(elem));
        }

        @Override
        public Object getInstance(String elem) {
            if (elem == null) {
                throw new NullPointerException("The boolean passed in was null");
            }
            return Boolean.valueOf(elem);
        }

        @Override
        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Boolean;
        }

        @Override
        public boolean isClass(Class c) {
            return c != null && (Boolean.class.equals((Object)c) || Boolean.TYPE.equals(c));
        }

        @Override
        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The boolean obj passed in was null");
            }
            if (!(obj instanceof Boolean)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            return "<boolean>" + ((Boolean)obj).toString() + "</boolean>\n";
        }

        @Override
        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class URIMapping
    implements Mapping {
        protected URIMapping() {
        }

        @Override
        public String getType() {
            return "xs:anyURI";
        }

        @Override
        public String getElementName() {
            return "anyURI";
        }

        @Override
        public Object getInstance(Element elem) throws ValidationException {
            if (elem == null) {
                throw new NullPointerException("The anyUri passed in was null");
            }
            try {
                return new URI(ReaderUtils.getElementText(elem).trim());
            }
            catch (URISyntaxException e) {
                throw new ValidationException(e);
            }
        }

        @Override
        public Object getInstance(String value) throws ValidationException {
            if (value == null) {
                throw new NullPointerException("The anyUri passed in was null");
            }
            try {
                return new URI(value);
            }
            catch (URISyntaxException e) {
                throw new ValidationException(e);
            }
        }

        @Override
        public boolean isClassInstance(Object c) {
            return c != null && c instanceof URI;
        }

        @Override
        public boolean isClass(Class c) {
            return c != null && URI.class.equals((Object)c);
        }

        @Override
        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The anyUri obj passed in was null");
            }
            if (!(obj instanceof URI)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            return "<anyURI>" + ((URI)obj).toString() + "</anyURI>\n";
        }

        @Override
        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class DateMapping
    implements Mapping {
        protected DateMapping() {
        }

        @Override
        public String getType() {
            return "xs:dateTime";
        }

        @Override
        public String getElementName() {
            return "dateTime";
        }

        @Override
        public Object getInstance(Element elem) throws ValidationException {
            if (elem == null) {
                throw new NullPointerException("The dateTime passed in was null");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd'T'hh:mm:ssZ");
            try {
                return sdf.parse(ReaderUtils.getElementText(elem));
            }
            catch (ParseException e) {
                throw new ValidationException(e);
            }
        }

        @Override
        public Object getInstance(String elem) throws ValidationException {
            if (elem == null) {
                throw new NullPointerException("The dateTime passed in was null");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd'T'hh:mm:ssZ");
            try {
                return sdf.parse(elem);
            }
            catch (ParseException e) {
                throw new ValidationException(e);
            }
        }

        @Override
        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Date;
        }

        @Override
        public boolean isClass(Class c) {
            return c != null && Date.class.equals((Object)c);
        }

        @Override
        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The dateTime obj passed in was null");
            }
            if (!(obj instanceof Date)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd'T'hh:mm:ssZ");
            return "<dateTime>" + sdf.format((Date)obj) + "</dateTime>\n";
        }

        @Override
        public String toString(Object o) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd'T'hh:mm:ssZ");
            return sdf.format((Date)o);
        }
    }

    protected static class DoubleMapping
    implements Mapping {
        protected DoubleMapping() {
        }

        @Override
        public String getType() {
            return "xs:double";
        }

        @Override
        public String getElementName() {
            return "double";
        }

        @Override
        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The double passed in was null");
            }
            return Double.valueOf(ReaderUtils.getElementText(elem));
        }

        @Override
        public Object getInstance(String elem) {
            if (elem == null) {
                throw new NullPointerException("The double passed in was null");
            }
            return Double.valueOf(elem);
        }

        @Override
        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Double;
        }

        @Override
        public boolean isClass(Class c) {
            return c != null && (Double.class.equals((Object)c) || Double.TYPE.equals(c));
        }

        @Override
        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The double obj passed in was null");
            }
            if (!(obj instanceof Double)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            return "<double>" + ((Double)obj).toString() + "</double>\n";
        }

        @Override
        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class FloatMapping
    implements Mapping {
        protected FloatMapping() {
        }

        @Override
        public String getType() {
            return "xs:float";
        }

        @Override
        public String getElementName() {
            return "float";
        }

        @Override
        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The float passed in was null");
            }
            return Float.valueOf(ReaderUtils.getElementText(elem));
        }

        @Override
        public Object getInstance(String elem) {
            if (elem == null) {
                throw new NullPointerException("The float passed in was null");
            }
            return Float.valueOf(elem);
        }

        @Override
        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Float;
        }

        @Override
        public boolean isClass(Class c) {
            return c != null && (Float.class.equals((Object)c) || Float.TYPE.equals(c));
        }

        @Override
        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The float obj passed in was null");
            }
            if (!(obj instanceof Float)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            return "<float>" + ((Float)obj).toString() + "</float>\n";
        }

        @Override
        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class LongMapping
    implements Mapping {
        protected LongMapping() {
        }

        @Override
        public String getType() {
            return "xs:long";
        }

        @Override
        public String getElementName() {
            return "long";
        }

        @Override
        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The long passed in was null");
            }
            return Long.valueOf(ReaderUtils.getElementText(elem));
        }

        @Override
        public Object getInstance(String value) {
            if (value == null) {
                throw new NullPointerException("The long passed in was null");
            }
            return Long.valueOf(value);
        }

        @Override
        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Long;
        }

        @Override
        public boolean isClass(Class c) {
            return c != null && (Long.class.equals((Object)c) || Long.TYPE.equals(c));
        }

        @Override
        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The long obj passed in was null");
            }
            if (!(obj instanceof Long)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            return "<long>" + ((Long)obj).toString() + "</long>\n";
        }

        @Override
        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class IntegerMapping
    implements Mapping {
        protected IntegerMapping() {
        }

        @Override
        public String getType() {
            return "xs:integer";
        }

        @Override
        public String getElementName() {
            return "integer";
        }

        @Override
        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The integer passed in was null");
            }
            return Integer.valueOf(ReaderUtils.getElementText(elem));
        }

        @Override
        public Object getInstance(String value) {
            if (value == null) {
                throw new NullPointerException("The integer passed in was null");
            }
            return Integer.valueOf(value);
        }

        @Override
        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Integer;
        }

        @Override
        public boolean isClass(Class c) {
            return c != null && (Integer.class.equals((Object)c) || Integer.TYPE.equals(c));
        }

        @Override
        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The integer obj passed in was null");
            }
            if (!(obj instanceof Integer)) {
                throw new ClassCastException("Object of type Integer was expected.");
            }
            return "<integer>" + ((Integer)obj).toString() + "</integer>\n";
        }

        @Override
        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class ShortMapping
    implements Mapping {
        protected ShortMapping() {
        }

        @Override
        public String getType() {
            return "xs:short";
        }

        @Override
        public String getElementName() {
            return "short";
        }

        @Override
        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The short element passed in was null");
            }
            return Short.valueOf(ReaderUtils.getElementText(elem));
        }

        @Override
        public Object getInstance(String value) {
            if (value == null) {
                throw new NullPointerException("The short element passed in was null");
            }
            return Short.valueOf(value);
        }

        @Override
        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Short;
        }

        @Override
        public boolean isClass(Class c) {
            return c != null && (Short.class.equals((Object)c) || Short.TYPE.equals(c));
        }

        @Override
        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The short obj passed in was null");
            }
            if (!(obj instanceof Short)) {
                throw new ClassCastException("Object of type Short was expected.");
            }
            return "<short>" + ((Short)obj).toString() + "</short>\n";
        }

        @Override
        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class EnvelopeMapping
    implements Mapping {
        protected EnvelopeMapping() {
        }

        @Override
        public String getType() {
            return "ogc:BBOXType";
        }

        @Override
        public String getElementName() {
            return "bbox";
        }

        @Override
        public Object getInstance(Element bboxElem) throws ValidationException {
            if (bboxElem == null) {
                throw new NullPointerException("The bounding Box element passed in was null");
            }
            try {
                boolean dynamic = ReaderUtils.getBooleanAttribute(bboxElem, "dynamic", false);
                if (!dynamic) {
                    double minx = ReaderUtils.getDoubleAttribute(bboxElem, "minx", true);
                    double miny = ReaderUtils.getDoubleAttribute(bboxElem, "miny", true);
                    double maxx = ReaderUtils.getDoubleAttribute(bboxElem, "maxx", true);
                    double maxy = ReaderUtils.getDoubleAttribute(bboxElem, "maxy", true);
                    return new Envelope(minx, maxx, miny, maxy);
                }
            }
            catch (SAXException e) {
                throw new ValidationException(e);
            }
            return null;
        }

        @Override
        public Object getInstance(String bbox) throws ValidationException {
            if (bbox == null) {
                throw new NullPointerException("The bounding Box element passed in was null");
            }
            try {
                String[] tmp = bbox.split(",");
                double minx = Double.parseDouble(tmp[0].trim());
                double maxx = Double.parseDouble(tmp[1].trim());
                double miny = Double.parseDouble(tmp[2].trim());
                double maxy = Double.parseDouble(tmp[3].trim());
                return new Envelope(minx, maxx, miny, maxy);
            }
            catch (Exception e) {
                throw new ValidationException(e);
            }
        }

        @Override
        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Envelope;
        }

        @Override
        public boolean isClass(Class c) {
            return c != null && Envelope.class.equals((Object)c);
        }

        @Override
        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The bounding Box obj passed in was null");
            }
            if (!(obj instanceof Envelope)) {
                throw new ClassCastException("Object of type Envelope was expected.");
            }
            String s = "";
            Envelope e = (Envelope)obj;
            s = s + "<bbox ";
            if (!e.isNull()) {
                s = s + "dynamic = \"false\" ";
                s = s + "minx = \"" + e.getMinX() + "\" ";
                s = s + "miny = \"" + e.getMinY() + "\" ";
                s = s + "maxx = \"" + e.getMaxX() + "\" ";
                s = s + "maxy = \"" + e.getMaxY() + "\" ";
            } else {
                s = s + "dynamic = \"true\" ";
            }
            s = s + " />\n";
            return s;
        }

        @Override
        public String toString(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The bounding Box obj passed in was null");
            }
            if (!(obj instanceof Envelope)) {
                throw new ClassCastException("Object of type Envelope was expected.");
            }
            String s = "";
            Envelope e = (Envelope)obj;
            if (!e.isNull()) {
                s = s + e.getMinX();
                s = s + "," + e.getMaxX();
                s = s + "," + e.getMinY();
                s = s + "," + e.getMaxY();
            }
            return s;
        }
    }

    protected static class GeometryMapping
    implements Mapping {
        protected GeometryMapping() {
        }

        @Override
        public String getType() {
            return "gml:AbstractGeometryType";
        }

        @Override
        public String getElementName() {
            return "geometry";
        }

        @Override
        public Object getInstance(Element value) {
            return new ExpressionDOMParser(FF).gml((Node)value);
        }

        @Override
        public Object getInstance(String value) {
            Element elem;
            try (StringReader sr = new StringReader(value);){
                elem = ReaderUtils.loadConfig(sr);
            }
            catch (IOException e) {
                Logger.getGlobal().log(Level.INFO, "", e);
                return null;
            }
            catch (ParserConfigurationException e) {
                Logger.getGlobal().log(Level.INFO, "", e);
                return null;
            }
            catch (SAXException e) {
                Logger.getGlobal().log(Level.INFO, "", e);
                return null;
            }
            return new ExpressionDOMParser(FF).gml((Node)elem);
        }

        @Override
        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Geometry;
        }

        @Override
        public boolean isClass(Class c) {
            return c != null && Geometry.class.equals((Object)c);
        }

        @Override
        public String encode(Object obj) throws ValidationException {
            StringWriter sw = new StringWriter();
            GeometryTransformer transformer = new GeometryTransformer();
            try {
                transformer.transform(obj, (Writer)sw);
            }
            catch (TransformerException e) {
                throw new ValidationException(e);
            }
            return "<geometry>\n" + sw.toString() + "</geometry>\n";
        }

        @Override
        public String toString(Object obj) {
            StringWriter sw = new StringWriter();
            GeometryTransformer transformer = new GeometryTransformer();
            try {
                transformer.transform(obj, (Writer)sw);
            }
            catch (TransformerException e) {
                return null;
            }
            return "<geometry>\n" + sw.toString() + "</geometry>\n";
        }
    }

    protected static class FilterMapping
    implements Mapping {
        protected FilterMapping() {
        }

        @Override
        public String getType() {
            return "ogc:FilterType";
        }

        @Override
        public String getElementName() {
            return "filter";
        }

        @Override
        public Object getInstance(Element value) {
            if (value != null && (value = ReaderUtils.getFirstChildElement(value)) != null) {
                return FilterDOMParser.parseFilter((Node)value);
            }
            return null;
        }

        @Override
        public Object getInstance(String elem) {
            Element value;
            try (StringReader sr = new StringReader(elem);){
                value = ReaderUtils.loadConfig(sr);
            }
            catch (IOException e) {
                Logger.getGlobal().log(Level.INFO, "", e);
                return null;
            }
            catch (ParserConfigurationException e) {
                Logger.getGlobal().log(Level.INFO, "", e);
                return null;
            }
            catch (SAXException e) {
                Logger.getGlobal().log(Level.INFO, "", e);
                return null;
            }
            if (value != null && (value = ReaderUtils.getFirstChildElement(value)) != null) {
                return FilterDOMParser.parseFilter((Node)value);
            }
            return null;
        }

        @Override
        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Filter;
        }

        @Override
        public boolean isClass(Class c) {
            return c != null && Filter.class.equals((Object)c);
        }

        @Override
        public String encode(Object obj) throws ValidationException {
            Filter f = null;
            if (obj == null) {
                throw new NullPointerException("Cannot encode a null Filter.");
            }
            if (!(obj instanceof Filter)) {
                throw new ClassCastException("Cannot cast " + obj.getClass().toString() + " to a Filter.");
            }
            f = (Filter)obj;
            StringWriter sw = new StringWriter();
            try {
                sw.write(new FilterTransformer().transform(f));
            }
            catch (TransformerException e) {
                throw new ValidationException(e);
            }
            return "<filter>\n" + sw.toString() + "</filter>\n";
        }

        @Override
        public String toString(Object obj) {
            Filter f = null;
            if (obj == null) {
                throw new NullPointerException("Cannot encode a null Filter.");
            }
            if (!(obj instanceof Filter)) {
                throw new ClassCastException("Cannot cast " + obj.getClass().toString() + " to a Filter.");
            }
            f = (Filter)obj;
            StringWriter sw = new StringWriter();
            try {
                sw.write(new FilterTransformer().transform(f));
            }
            catch (TransformerException e) {
                return null;
            }
            return "<filter>\n" + sw.toString() + "</filter>\n";
        }
    }

    protected static interface Mapping {
        public String getType();

        public Object getInstance(Element var1) throws ValidationException;

        public Object getInstance(String var1) throws ValidationException;

        public boolean isClassInstance(Object var1);

        public boolean isClass(Class var1);

        public String encode(Object var1) throws ValidationException;

        public String toString(Object var1);

        public String getElementName();
    }
}

