/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import java.util.Map;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LinePolygonAbstractValidation;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;

public class LineNotTouchingPolygonInteriorValidation
extends LinePolygonAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        boolean r = true;
        SimpleFeatureSource fsLine = (SimpleFeatureSource)layers.get(this.getLineTypeRef());
        if (fsLine == null) {
            return true;
        }
        SimpleFeatureCollection fcLine = fsLine.getFeatures();
        try (SimpleFeatureIterator fLine = fcLine.features();){
            SimpleFeatureSource fsPoly = (SimpleFeatureSource)layers.get(this.getRestrictedPolygonTypeRef());
            if (fsPoly == null) {
                boolean bl = true;
                return bl;
            }
            ListFeatureCollection fcPoly = new ListFeatureCollection(fsPoly.getFeatures());
            while (fLine.hasNext()) {
                SimpleFeature line = (SimpleFeature)fLine.next();
                SimpleFeatureIterator fPoly = fcPoly.features();
                try {
                    Geometry lineGeom = (Geometry)line.getDefaultGeometry();
                    if (!envelope.contains(lineGeom.getEnvelopeInternal())) continue;
                    if (LineString.class.isAssignableFrom(lineGeom.getClass())) {
                        while (fPoly.hasNext()) {
                            SimpleFeature poly = (SimpleFeature)fPoly.next();
                            Geometry polyGeom = (Geometry)poly.getDefaultGeometry();
                            if (envelope.contains(polyGeom.getEnvelopeInternal())) {
                                if (Polygon.class.isAssignableFrom(polyGeom.getClass())) {
                                    Polygon p = (Polygon)polyGeom;
                                    for (int i = 0; i < p.getNumInteriorRing(); ++i) {
                                        if (p.getInteriorRingN(i).touches(lineGeom)) continue;
                                        results.error(poly, "Polygon interior touches the specified Line.");
                                    }
                                    continue;
                                }
                                fcPoly.remove((Object)poly);
                                results.warning(poly, "Invalid type: this feature is not a derivative of a Polygon");
                                continue;
                            }
                            fcPoly.remove((Object)poly);
                        }
                        continue;
                    }
                    results.warning(line, "Invalid type: this feature is not a derivative of a LineString");
                }
                finally {
                    if (fPoly == null) continue;
                    fPoly.close();
                }
            }
        }
        return r;
    }
}

