/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geotools.validation.DefaultFeatureValidation;
import org.geotools.validation.ValidationResults;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class LineNoSelfOverlappingValidation
extends DefaultFeatureValidation {
    private static final Logger LOGGER = Logging.getLogger(LineNoSelfOverlappingValidation.class);

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public boolean validate(SimpleFeature feature, SimpleFeatureType type, ValidationResults results) {
        int i;
        LOGGER.setLevel(Level.ALL);
        LineString line = null;
        try {
            line = this.getDefaultLineString(feature);
        }
        catch (ClassCastException unLine) {
            results.error(feature, "Geometry is required to be a LineString");
        }
        if (line == null) {
            return true;
        }
        if (line.getNumPoints() < 2) {
            results.warning(feature, "LineString contains too few points");
            return false;
        }
        GeometryFactory gf = new GeometryFactory();
        int numPoints = line.getNumPoints();
        LineString[] segments = new LineString[numPoints - 1];
        for (i = 0; i < numPoints - 1; ++i) {
            Coordinate[] coords = new Coordinate[]{line.getCoordinateN(i), line.getCoordinateN(i + 1)};
            segments[i] = gf.createLineString(coords);
        }
        for (i = 0; i < segments.length; ++i) {
            for (int j = 0; j < segments.length; ++j) {
                if (i == j || !segments[i].relate((Geometry)segments[j], "1********")) continue;
                results.error(feature, "LineString overlapped itself.");
                return false;
            }
        }
        return true;
    }
}

