/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import java.util.HashSet;
import java.util.Map;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LineLineAbstractValidation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.simple.SimpleFeature;

public class LineIntersectsLineWithNodeValidation
extends LineLineAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        boolean r = true;
        SimpleFeatureSource fsLine = (SimpleFeatureSource)layers.get(this.getLineTypeRef());
        SimpleFeatureCollection fcLine = fsLine.getFeatures();
        try (SimpleFeatureIterator fLine = fcLine.features();){
            SimpleFeatureSource fsRLine = (SimpleFeatureSource)layers.get(this.getRestrictedLineTypeRef());
            ListFeatureCollection fcRLine = new ListFeatureCollection(fsRLine.getFeatures());
            while (fLine.hasNext()) {
                SimpleFeature line = (SimpleFeature)fLine.next();
                SimpleFeatureIterator fRLine = fcRLine.features();
                try {
                    Geometry lineGeom = (Geometry)line.getDefaultGeometry();
                    if (!envelope.contains(lineGeom.getEnvelopeInternal())) continue;
                    if (LineString.class.isAssignableFrom(lineGeom.getClass())) {
                        while (fRLine.hasNext()) {
                            SimpleFeature rLine = (SimpleFeature)fRLine.next();
                            Geometry rLineGeom = (Geometry)rLine.getDefaultGeometry();
                            if (envelope.contains(rLineGeom.getEnvelopeInternal())) {
                                if (LineString.class.isAssignableFrom(rLineGeom.getClass())) {
                                    if (lineGeom.intersects(rLineGeom)) {
                                        if (this.hasPair(((LineString)lineGeom).getCoordinateSequence(), ((LineString)rLineGeom).getCoordinateSequence())) continue;
                                        results.error(rLine, "Line does not intersect line at node covered by the specified Line.");
                                        r = false;
                                        continue;
                                    }
                                    results.warning(rLine, "Does not intersect the LineString");
                                    continue;
                                }
                                fcRLine.remove((Object)rLine);
                                results.warning(rLine, "Invalid type: this feature is not a derivative of a LineString");
                                continue;
                            }
                            fcRLine.remove((Object)rLine);
                        }
                        continue;
                    }
                    results.warning(line, "Invalid type: this feature is not a derivative of a LineString");
                }
                finally {
                    if (fRLine == null) continue;
                    fRLine.close();
                }
            }
        }
        return r;
    }

    private boolean hasPair(CoordinateSequence a1, CoordinateSequence a2) {
        int i;
        CoordinateSequence c = a1;
        HashSet<Coordinate> m = new HashSet<Coordinate>();
        for (i = 0; i < c.size(); ++i) {
            m.add(c.getCoordinate(i));
        }
        c = a2;
        for (i = 0; i < c.size(); ++i) {
            if (m.add(c.getCoordinate(i))) continue;
            return true;
        }
        return false;
    }
}

