/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geotools.validation.DefaultFeatureValidation;
import org.geotools.validation.ValidationResults;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class IsValidGeometryValidation
extends DefaultFeatureValidation {
    private static final Logger LOGGER = Logging.getLogger(IsValidGeometryValidation.class);

    @Override
    public int getPriority() {
        return 100;
    }

    public String[] getTypeNames() {
        if (this.getTypeRef() == null) {
            return null;
        }
        if (this.getTypeRef().equals("*")) {
            return new String[0];
        }
        return new String[]{this.getTypeRef()};
    }

    @Override
    public boolean validate(SimpleFeature feature, SimpleFeatureType type, ValidationResults results) {
        Geometry geom = (Geometry)feature.getDefaultGeometry();
        if (geom == null) {
            if (type.getGeometryDescriptor().isNillable()) {
                LOGGER.log(Level.FINEST, this.getName() + "(" + feature.getID() + ") passed");
                return true;
            }
            String message = "Geometry was null but is not nillable.";
            results.error(feature, message);
            LOGGER.log(Level.FINEST, this.getName() + "(" + feature.getID() + "):" + message);
            return false;
        }
        if (!geom.isValid()) {
            String message = "Not a valid geometry. isValid() failed";
            LOGGER.log(Level.FINEST, this.getName() + "(" + feature.getID() + "):" + message);
            results.error(feature, message);
            return false;
        }
        LOGGER.log(Level.FINEST, this.getName() + "(" + feature.getID() + ") passed");
        return true;
    }
}

