/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2004-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.validation.attributes;

import org.geotools.validation.DefaultFeatureValidation;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/**
 * PointCoveredByLineValidation purpose.
 *
 * <p>SQL Validation
 *
 * @author dzwiers, Refractions Research, Inc.
 * @author $Author: dmzwiers $ (last modification)
 * @version $Id$
 */
public class SQLValidation extends DefaultFeatureValidation {
    private String sql;

    /**
     * PointCoveredByLineValidation constructor.
     *
     * <p>Super
     */
    public SQLValidation() {
        super();
    }

    /**
     * SQL Validation
     *
     * @param feature Feature to be Validated
     * @param type FeatureTypeInfo schema of feature
     * @param results coallate results information
     * @see org.geotools.validation.FeatureValidation#validate(org.geotools.feature.Feature,
     *     org.geotools.feature.FeatureType, org.geotools.validation.ValidationResults)
     */
    public boolean validate(
            SimpleFeature feature, SimpleFeatureType type, ValidationResults results) {
        return false;
    }

    /**
     * Access lineTypeRef property.
     *
     * @return Returns the sql.
     */
    public String getSql() {
        return sql;
    }

    /**
     * Set lineTypeRef to lineTypeRef.
     *
     * @param sql The sql to set.
     */
    public void setSql(String sql) {
        this.sql = sql;
    }
}
