/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class SingleFeatureSourceDataStore
implements DataStore {
    SimpleFeatureSource source;

    public SingleFeatureSourceDataStore(SimpleFeatureSource fs) {
        this.source = fs;
    }

    public ServiceInfo getInfo() {
        try {
            DefaultServiceInfo info = new DefaultServiceInfo();
            SimpleFeatureType schema = (SimpleFeatureType)this.source.getSchema();
            info.setDescription("Features from " + schema.getName());
            info.setSchema(new URI(schema.getName().getNamespaceURI()));
            info.setTitle(schema.getName().toString());
            return info;
        }
        catch (Exception e) {
            throw new RuntimeException("Feature source returned an invalid namespace URI", e);
        }
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public List<Name> getNames() throws IOException {
        return Arrays.asList(((SimpleFeatureType)this.source.getSchema()).getName());
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        SimpleFeatureType schema = (SimpleFeatureType)this.source.getSchema();
        if (schema.getName().equals((Object)name)) {
            return schema;
        }
        return null;
    }

    public void dispose() {
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void removeSchema(Name typeName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void removeSchema(String typeName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String[] getTypeNames() throws IOException {
        return new String[]{((SimpleFeatureType)this.source.getSchema()).getName().getLocalPart()};
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        SimpleFeatureType schema = (SimpleFeatureType)this.source.getSchema();
        if (schema.getName().getLocalPart().equals(typeName)) {
            return schema;
        }
        throw new IOException("Schema '" + typeName + "' does not exist.");
    }

    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        SimpleFeatureType schema = (SimpleFeatureType)this.source.getSchema();
        if (schema.getName().getLocalPart().equals(typeName)) {
            return this.source;
        }
        throw new IOException("Schema '" + typeName + "' does not exist.");
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        SimpleFeatureType schema = (SimpleFeatureType)this.source.getSchema();
        if (schema.getName().equals((Object)typeName)) {
            return this.source;
        }
        throw new IOException("Schema '" + typeName + "' does not exist.");
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("This store is wrapping a FeatureSource/FeatureStore, which handles transactions in a stateful way as opposed to a per call way. You should get the feature source and use that one instead");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("This store is wrapping a FeatureSource/FeatureStore, which handles transactions in a stateful way as opposed to a per call way. You should get the feature source and use that one instead");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("This store is wrapping a FeatureSource/FeatureStore, which handles transactions in a stateful way as opposed to a per call way. You should get the feature source and use that one instead");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("This store is wrapping a FeatureSource/FeatureStore, which handles transactions in a stateful way as opposed to a per call way. You should get the feature source and use that one instead");
    }

    public LockingManager getLockingManager() {
        return null;
    }
}

