/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;

class TransformFilterVisitor
extends DuplicatingFilterVisitor {
    private final String sourceName;
    private final String targetName;
    private final Map<String, Expression> expressions;

    public TransformFilterVisitor(String sourceName, String targetName, Map<String, Expression> expressions) {
        this.sourceName = sourceName;
        this.targetName = targetName;
        this.expressions = expressions;
    }

    public Object visit(Id filter, Object extraData) {
        Set ids = filter.getIDs();
        if (ids.isEmpty()) {
            throw new IllegalArgumentException("Invalid fid filter provides, has no fids inside");
        }
        if (this.sourceName.equals(this.targetName)) {
            return filter;
        }
        HashSet<FeatureId> fids = new HashSet<FeatureId>();
        for (Object o : ids) {
            FeatureIdImpl id = new FeatureIdImpl((String)o);
            FeatureId retyped = this.reTypeId((FeatureId)id);
            fids.add(retyped);
        }
        return this.ff.id(fids);
    }

    public FeatureId reTypeId(FeatureId sourceId) {
        String prefix = this.targetName + ".";
        if (sourceId.getID().startsWith(prefix)) {
            return new FeatureIdImpl(this.sourceName + "." + sourceId.getID().substring(prefix.length()));
        }
        return sourceId;
    }

    public Object visit(PropertyName expression, Object extraData) {
        String name = expression.getPropertyName();
        Expression ex = this.expressions.get(name);
        if (ex == null) {
            return super.visit(expression, extraData);
        }
        return ex;
    }
}

