/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tpk;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.coverage.grid.GridCoverageWriter;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.tpk.TPKReader;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class TPKFormat
extends AbstractGridFormat {
    private static final Logger LOGGER = Logging.getLogger(TPKFormat.class);

    public static File getFileFromSource(Object source) {
        if (source == null) {
            return null;
        }
        File sourceFile = null;
        try {
            if (source instanceof File) {
                sourceFile = (File)source;
            } else if (source instanceof URL) {
                if (((URL)source).getProtocol().equals("file")) {
                    sourceFile = URLs.urlToFile((URL)((URL)source));
                }
            } else if (source instanceof String) {
                sourceFile = new File((String)source);
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        return sourceFile;
    }

    public AbstractGridCoverage2DReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
        return new TPKReader(source, hints);
    }

    public GridCoverageWriter getWriter(Object destination) {
        return this.getWriter(destination, null);
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("Unsupported method: TPK format is read-only.");
    }

    public boolean accepts(Object source, Hints hints) {
        if (source == null) {
            return false;
        }
        File sourceFile = TPKFormat.getFileFromSource(source);
        if (sourceFile == null) {
            return false;
        }
        return sourceFile.getName().matches("^.*\\.tpkx*$");
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }

    public TPKFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "TPK");
        info.put("description", "TPK (ESRI Compact Cache) plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D}));
        this.writeParameters = null;
    }
}

