/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tpk;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.geotools.tpk.TPKBundle;
import org.geotools.tpk.TPKTile;
import org.geotools.tpk.TPKZoomLevel;

public class TPKZoomLevelV1
implements TPKZoomLevel {
    static Pattern PARSE_BUNDLE_NAME = Pattern.compile("^.*/R([0-9a-f]+)C([0-9a-f]+)\\.bundle$");
    static int BUNDLE_DIMENSION = 128;
    static int INDEX_ENTRY_LENGTH = 5;
    static int INDEX_HEADER_LENGTH = 16;
    static int DATA_HEADER_LENGTH = 60;
    static int DATA_LENGTH_LENGTH = 4;
    static int HEXADECIMAL = 16;
    static int MINIMUM_DATA_OFFSET = DATA_HEADER_LENGTH + BUNDLE_DIMENSION * BUNDLE_DIMENSION * DATA_LENGTH_LENGTH;
    private ZipFile theTPK;
    private Map<String, ZipEntry> zipEntryMap;
    private final long zoomLevel;
    private long minRow;
    private long maxRow;
    private long minColumn;
    private long maxColumn;
    private long max_row_column;
    private List<TPKBundle> bundles;

    public TPKZoomLevelV1(ZipFile theTPK, Map<String, ZipEntry> zipEntryMap, List<String> bundleNames, List<String> indexNames, long zoomLevel) {
        this.theTPK = theTPK;
        this.zipEntryMap = zipEntryMap;
        this.zoomLevel = zoomLevel;
        this.minColumn = Long.MAX_VALUE;
        this.maxColumn = Long.MIN_VALUE;
        this.minRow = Long.MAX_VALUE;
        this.maxRow = Long.MIN_VALUE;
        this.max_row_column = (long)(Math.pow(2.0, zoomLevel) - 1.0);
        this.bundles = new ArrayList<TPKBundle>();
        this.init(bundleNames, indexNames);
    }

    @Override
    public void setTPKandEntryMap(ZipFile theTPK, Map<String, ZipEntry> zipEntryMap) {
        this.theTPK = theTPK;
        this.zipEntryMap = zipEntryMap;
    }

    @Override
    public List<TPKTile> getTiles(long top, long bottom, long left, long right, String format) {
        List<TPKTile> tiles = this.makeTileSet(top, bottom, left, right, format);
        tiles.stream().sorted(new TPKTile.TPKTileSorter()).forEach(this::readTileData);
        return tiles;
    }

    @Override
    public void releaseResources() {
        this.bundles.forEach(TPKBundle::releaseResources);
        this.zipEntryMap = null;
        this.theTPK = null;
    }

    @Override
    public long getZoomLevel() {
        return this.zoomLevel;
    }

    @Override
    public long getMinRow() {
        return this.minRow;
    }

    @Override
    public long getMaxRow() {
        return this.maxRow;
    }

    @Override
    public long getMinColumn() {
        return this.minColumn;
    }

    @Override
    public long getMaxColumn() {
        return this.maxColumn;
    }

    private void init(List<String> bundleNames, List<String> indexNames) {
        for (String bundleName : bundleNames) {
            Matcher m = PARSE_BUNDLE_NAME.matcher(bundleName);
            if (m.matches()) {
                String row_start = m.group(1);
                String col_start = m.group(2);
                String indexName = bundleName.replace("bundle", "bundlx");
                if (!indexNames.contains(indexName)) continue;
                this.parseBundle(bundleName, indexName, row_start, col_start);
                continue;
            }
            throw new RuntimeException("Unable to parse bundle name??");
        }
    }

    private void parseBundle(String bundleName, String indexName, String row_start, String col_start) {
        long baseRow = Long.parseLong(row_start, HEXADECIMAL);
        long baseColumn = Long.parseLong(col_start, HEXADECIMAL);
        if (baseRow <= this.max_row_column && baseColumn <= this.max_row_column) {
            TPKBundle bundle = new TPKBundle(bundleName, indexName, baseColumn, baseRow, this::TPKSupplier, this::zipEntryMapSupplier);
            long indexReadOffset = INDEX_HEADER_LENGTH;
            for (int col = 0; col < BUNDLE_DIMENSION; ++col) {
                for (int row = 0; row < BUNDLE_DIMENSION; ++row) {
                    long thisRow = baseRow + (long)row;
                    long thisColumn = baseColumn + (long)col;
                    long tileDataOffset = this.getTileDataOffset(bundle, indexReadOffset);
                    if (thisColumn <= this.max_row_column && thisRow <= this.max_row_column) {
                        thisRow = this.max_row_column - thisRow;
                        if (tileDataOffset >= (long)MINIMUM_DATA_OFFSET) {
                            bundle.minRow = Math.min(bundle.minRow, thisRow);
                            bundle.maxRow = Math.max(bundle.maxRow, thisRow);
                            bundle.minColumn = Math.min(bundle.minColumn, thisColumn);
                            bundle.maxColumn = Math.max(bundle.maxColumn, thisColumn);
                        }
                    }
                    if (thisColumn == this.max_row_column && thisRow > this.max_row_column) {
                        col = BUNDLE_DIMENSION;
                        row = BUNDLE_DIMENSION;
                    }
                    indexReadOffset += (long)INDEX_ENTRY_LENGTH;
                }
            }
            this.minRow = Math.min(this.minRow, bundle.minRow);
            this.maxRow = Math.max(this.maxRow, bundle.maxRow);
            this.minColumn = Math.min(this.minColumn, bundle.minColumn);
            this.maxColumn = Math.max(this.maxColumn, bundle.maxColumn);
            this.bundles.add(bundle);
        }
    }

    private List<TPKTile> makeTileSet(long top, long bottom, long left, long right, String format) {
        TPKBundle bundle = this.bundles.get(0);
        int bundleIndex = 0;
        ArrayList<TPKTile> tiles = new ArrayList<TPKTile>();
        for (long col = left; col <= right; ++col) {
            for (long row = top; row >= bottom; --row) {
                if (!bundle.inBundle(col, row)) {
                    long c = col;
                    long r = row;
                    TPKBundle saveBundle = bundle;
                    bundle = this.bundles.stream().filter(b -> b.inBundle(c, r)).findFirst().orElse(null);
                    if (bundle == null) {
                        bundle = saveBundle;
                        continue;
                    }
                    bundleIndex = this.bundles.indexOf(bundle);
                }
                long bundleRow = this.max_row_column - row - bundle.baseRow;
                long indexReadOffset = (long)INDEX_HEADER_LENGTH + ((col - bundle.baseColumn) * (long)BUNDLE_DIMENSION + bundleRow) * (long)INDEX_ENTRY_LENGTH;
                long tileDataOffset = this.getTileDataOffset(bundle, indexReadOffset);
                TPKTile.TileInfo ti = new TPKTile.TileInfo(0, tileDataOffset);
                TPKTile tile = new TPKTile(this.zoomLevel, col, row, format, ti, bundleIndex);
                tiles.add(tile);
            }
        }
        return tiles;
    }

    private void readTileData(TPKTile tile) {
        TPKBundle bundle = this.bundles.get(tile.bundleNum);
        byte[] tileData = this.getTileData(bundle, tile.tileInfo.tileDataOffset);
        tile.setTileData(tileData);
    }

    private long getTileDataOffset(TPKBundle bundle, long indexReadOffset) {
        byte[] tileIndex = bundle.bundleIndx.read(indexReadOffset, INDEX_ENTRY_LENGTH);
        return (long)tileIndex[0] & 0xFFL | (long)(tileIndex[1] & 0xFF) << 8 | (long)(tileIndex[2] & 0xFF) << 16 | (long)(tileIndex[3] & 0xFF) << 24 | (long)(tileIndex[4] & 0xFF) << 32;
    }

    private byte[] getTileData(TPKBundle bundle, long tileDataOffset) {
        int dataLength = this.getTileDataLength(bundle, tileDataOffset);
        if (dataLength > 0) {
            return bundle.bundleData.read(tileDataOffset + (long)DATA_LENGTH_LENGTH, dataLength);
        }
        return null;
    }

    private int getTileDataLength(TPKBundle bundle, long tileDataOffset) {
        byte[] dataLen = bundle.bundleData.read(tileDataOffset, DATA_LENGTH_LENGTH);
        return dataLen[0] & 0xFF | (dataLen[1] & 0xFF) << 8 | (dataLen[2] & 0xFF) << 16 | (dataLen[3] & 0xFF) << 24;
    }

    private ZipFile TPKSupplier() {
        return this.theTPK;
    }

    private Map<String, ZipEntry> zipEntryMapSupplier() {
        return this.zipEntryMap;
    }
}

